/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.HttpResponse;
import be.maximvdw.featherboardcore.twitter.JSONArray;
import be.maximvdw.featherboardcore.twitter.JSONException;
import be.maximvdw.featherboardcore.twitter.JSONObject;
import be.maximvdw.featherboardcore.twitter.ParseUtil;
import be.maximvdw.featherboardcore.twitter.ResponseList;
import be.maximvdw.featherboardcore.twitter.ResponseListImpl;
import be.maximvdw.featherboardcore.twitter.SavedSearch;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import be.maximvdw.featherboardcore.twitter.TwitterObjectFactory;
import be.maximvdw.featherboardcore.twitter.TwitterResponseImpl;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SavedSearchJSONImpl
extends TwitterResponseImpl
implements SavedSearch {
    private static final long serialVersionUID = -2281949861485441692L;
    private Date createdAt;
    private String query;
    private int position;
    private String name;
    private long id;

    SavedSearchJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
        }
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.registerJSONObject(this, jSONObject);
        }
    }

    SavedSearchJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    static ResponseList<SavedSearch> createSavedSearchList(HttpResponse httpResponse, Configuration configuration) {
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
        }
        JSONArray jSONArray = httpResponse.asJSONArray();
        try {
            ResponseListImpl<SavedSearch> responseListImpl = new ResponseListImpl<SavedSearch>(jSONArray.length(), httpResponse);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                SavedSearchJSONImpl savedSearchJSONImpl = new SavedSearchJSONImpl(jSONObject);
                responseListImpl.add(savedSearchJSONImpl);
                if (!configuration.isJSONStoreEnabled()) continue;
                TwitterObjectFactory.registerJSONObject(savedSearchJSONImpl, jSONObject);
            }
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException.getMessage() + ":" + httpResponse.asString(), jSONException);
        }
    }

    private void init(JSONObject jSONObject) {
        this.createdAt = ParseUtil.getDate("created_at", jSONObject, "EEE MMM dd HH:mm:ss z yyyy");
        this.query = ParseUtil.getUnescapedString("query", jSONObject);
        this.position = ParseUtil.getInt("position", jSONObject);
        this.name = ParseUtil.getUnescapedString("name", jSONObject);
        this.id = ParseUtil.getLong("id", jSONObject);
    }

    @Override
    public int compareTo(SavedSearch savedSearch) {
        return (int)(this.id - savedSearch.getId());
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SavedSearch)) {
            return false;
        }
        SavedSearch savedSearch = (SavedSearch)object;
        return this.id == savedSearch.getId();
    }

    public int hashCode() {
        int n2 = this.createdAt.hashCode();
        n2 = 31 * n2 + this.query.hashCode();
        n2 = 31 * n2 + this.position;
        n2 = 31 * n2 + this.name.hashCode();
        n2 = 31 * n2 + (int)this.id;
        return n2;
    }

    public String toString() {
        return "SavedSearchJSONImpl{createdAt=" + this.createdAt + ", query='" + this.query + '\'' + ", position=" + this.position + ", name='" + this.name + '\'' + ", id=" + this.id + '}';
    }
}

