/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.GeoLocation;
import be.maximvdw.featherboardcore.twitter.HttpResponse;
import be.maximvdw.featherboardcore.twitter.JSONArray;
import be.maximvdw.featherboardcore.twitter.JSONException;
import be.maximvdw.featherboardcore.twitter.JSONImplFactory;
import be.maximvdw.featherboardcore.twitter.JSONObject;
import be.maximvdw.featherboardcore.twitter.ParseUtil;
import be.maximvdw.featherboardcore.twitter.Place;
import be.maximvdw.featherboardcore.twitter.ResponseList;
import be.maximvdw.featherboardcore.twitter.ResponseListImpl;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import be.maximvdw.featherboardcore.twitter.TwitterObjectFactory;
import be.maximvdw.featherboardcore.twitter.TwitterResponseImpl;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;
import java.io.Serializable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlaceJSONImpl
extends TwitterResponseImpl
implements Place,
Serializable {
    private static final long serialVersionUID = -6368276880878829754L;
    private String name;
    private String streetAddress;
    private String countryCode;
    private String id;
    private String country;
    private String placeType;
    private String url;
    private String fullName;
    private String boundingBoxType;
    private GeoLocation[][] boundingBoxCoordinates;
    private String geometryType;
    private GeoLocation[][] geometryCoordinates;
    private Place[] containedWithIn;

    PlaceJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, jSONObject);
        }
    }

    PlaceJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    PlaceJSONImpl() {
    }

    private void init(JSONObject jSONObject) {
        try {
            JSONArray jSONArray;
            Object object;
            this.name = ParseUtil.getUnescapedString("name", jSONObject);
            this.streetAddress = ParseUtil.getUnescapedString("street_address", jSONObject);
            this.countryCode = ParseUtil.getRawString("country_code", jSONObject);
            this.id = ParseUtil.getRawString("id", jSONObject);
            this.country = ParseUtil.getRawString("country", jSONObject);
            this.placeType = !jSONObject.isNull("place_type") ? ParseUtil.getRawString("place_type", jSONObject) : ParseUtil.getRawString("type", jSONObject);
            this.url = ParseUtil.getRawString("url", jSONObject);
            this.fullName = ParseUtil.getRawString("full_name", jSONObject);
            if (!jSONObject.isNull("bounding_box")) {
                object = jSONObject.getJSONObject("bounding_box");
                this.boundingBoxType = ParseUtil.getRawString("type", (JSONObject)object);
                jSONArray = ((JSONObject)object).getJSONArray("coordinates");
                this.boundingBoxCoordinates = JSONImplFactory.coordinatesAsGeoLocationArray(jSONArray);
            } else {
                this.boundingBoxType = null;
                this.boundingBoxCoordinates = null;
            }
            if (!jSONObject.isNull("geometry")) {
                object = jSONObject.getJSONObject("geometry");
                this.geometryType = ParseUtil.getRawString("type", (JSONObject)object);
                jSONArray = ((JSONObject)object).getJSONArray("coordinates");
                if (this.geometryType.equals("Point")) {
                    this.geometryCoordinates = new GeoLocation[1][1];
                    this.geometryCoordinates[0][0] = new GeoLocation(jSONArray.getDouble(1), jSONArray.getDouble(0));
                } else if (this.geometryType.equals("Polygon")) {
                    this.geometryCoordinates = JSONImplFactory.coordinatesAsGeoLocationArray(jSONArray);
                } else {
                    this.geometryType = null;
                    this.geometryCoordinates = null;
                }
            } else {
                this.geometryType = null;
                this.geometryCoordinates = null;
            }
            if (!jSONObject.isNull("contained_within")) {
                object = jSONObject.getJSONArray("contained_within");
                this.containedWithIn = new Place[((JSONArray)object).length()];
                for (int i2 = 0; i2 < ((JSONArray)object).length(); ++i2) {
                    this.containedWithIn[i2] = new PlaceJSONImpl(((JSONArray)object).getJSONObject(i2));
                }
            } else {
                this.containedWithIn = null;
            }
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    @Override
    public int compareTo(Place place) {
        return this.id.compareTo(place.getId());
    }

    static ResponseList<Place> createPlaceList(HttpResponse httpResponse, Configuration configuration) {
        JSONObject jSONObject = null;
        try {
            jSONObject = httpResponse.asJSONObject();
            return PlaceJSONImpl.createPlaceList(jSONObject.getJSONObject("result").getJSONArray("places"), httpResponse, configuration);
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    static ResponseList<Place> createPlaceList(JSONArray jSONArray, HttpResponse httpResponse, Configuration configuration) {
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
        }
        try {
            int n2 = jSONArray.length();
            ResponseListImpl<Place> responseListImpl = new ResponseListImpl<Place>(n2, httpResponse);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                PlaceJSONImpl placeJSONImpl = new PlaceJSONImpl(jSONObject);
                responseListImpl.add(placeJSONImpl);
                if (!configuration.isJSONStoreEnabled()) continue;
                TwitterObjectFactory.registerJSONObject(placeJSONImpl, jSONObject);
            }
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStreetAddress() {
        return this.streetAddress;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public String getPlaceType() {
        return this.placeType;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getBoundingBoxType() {
        return this.boundingBoxType;
    }

    @Override
    public GeoLocation[][] getBoundingBoxCoordinates() {
        return this.boundingBoxCoordinates;
    }

    @Override
    public String getGeometryType() {
        return this.geometryType;
    }

    @Override
    public GeoLocation[][] getGeometryCoordinates() {
        return this.geometryCoordinates;
    }

    @Override
    public Place[] getContainedWithIn() {
        return this.containedWithIn;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return object instanceof Place && ((Place)object).getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "PlaceJSONImpl{name='" + this.name + '\'' + ", streetAddress='" + this.streetAddress + '\'' + ", countryCode='" + this.countryCode + '\'' + ", id='" + this.id + '\'' + ", country='" + this.country + '\'' + ", placeType='" + this.placeType + '\'' + ", url='" + this.url + '\'' + ", fullName='" + this.fullName + '\'' + ", boundingBoxType='" + this.boundingBoxType + '\'' + ", boundingBoxCoordinates=" + (this.boundingBoxCoordinates == null ? null : Arrays.asList(this.boundingBoxCoordinates)) + ", geometryType='" + this.geometryType + '\'' + ", geometryCoordinates=" + (this.geometryCoordinates == null ? null : Arrays.asList(this.geometryCoordinates)) + ", containedWithIn=" + (this.containedWithIn == null ? null : Arrays.asList(this.containedWithIn)) + '}';
    }
}

