/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.EntityIndex;
import be.maximvdw.featherboardcore.twitter.JSONArray;
import be.maximvdw.featherboardcore.twitter.JSONException;
import be.maximvdw.featherboardcore.twitter.JSONObject;
import be.maximvdw.featherboardcore.twitter.MediaEntity;
import be.maximvdw.featherboardcore.twitter.ParseUtil;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaEntityJSONImpl
extends EntityIndex
implements MediaEntity {
    private static final long serialVersionUID = 3609683338035442290L;
    protected long id;
    protected String url;
    protected String mediaURL;
    protected String mediaURLHttps;
    protected String expandedURL;
    protected String displayURL;
    protected Map<Integer, MediaEntity.Size> sizes;
    protected String type;

    MediaEntityJSONImpl(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("indices");
            this.setStart(jSONArray.getInt(0));
            this.setEnd(jSONArray.getInt(1));
            this.id = ParseUtil.getLong("id", jSONObject);
            this.url = jSONObject.getString("url");
            this.expandedURL = jSONObject.getString("expanded_url");
            this.mediaURL = jSONObject.getString("media_url");
            this.mediaURLHttps = jSONObject.getString("media_url_https");
            this.displayURL = jSONObject.getString("display_url");
            JSONObject jSONObject2 = jSONObject.getJSONObject("sizes");
            this.sizes = new HashMap<Integer, MediaEntity.Size>(4);
            this.addMediaEntitySizeIfNotNull(this.sizes, jSONObject2, MediaEntity.Size.LARGE, "large");
            this.addMediaEntitySizeIfNotNull(this.sizes, jSONObject2, MediaEntity.Size.MEDIUM, "medium");
            this.addMediaEntitySizeIfNotNull(this.sizes, jSONObject2, MediaEntity.Size.SMALL, "small");
            this.addMediaEntitySizeIfNotNull(this.sizes, jSONObject2, MediaEntity.Size.THUMB, "thumb");
            if (!jSONObject.isNull("type")) {
                this.type = jSONObject.getString("type");
            }
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    private void addMediaEntitySizeIfNotNull(Map<Integer, MediaEntity.Size> map, JSONObject jSONObject, Integer n2, String string) {
        if (!jSONObject.isNull(string)) {
            map.put(n2, new Size(jSONObject.getJSONObject(string)));
        }
    }

    MediaEntityJSONImpl() {
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getMediaURL() {
        return this.mediaURL;
    }

    @Override
    public String getMediaURLHttps() {
        return this.mediaURLHttps;
    }

    @Override
    public String getText() {
        return this.url;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getDisplayURL() {
        return this.displayURL;
    }

    @Override
    public String getExpandedURL() {
        return this.expandedURL;
    }

    @Override
    public Map<Integer, MediaEntity.Size> getSizes() {
        return this.sizes;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getStart() {
        return super.getStart();
    }

    @Override
    public int getEnd() {
        return super.getEnd();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaEntityJSONImpl)) {
            return false;
        }
        MediaEntityJSONImpl mediaEntityJSONImpl = (MediaEntityJSONImpl)object;
        return this.id == mediaEntityJSONImpl.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "MediaEntityJSONImpl{id=" + this.id + ", url=" + this.url + ", mediaURL=" + this.mediaURL + ", mediaURLHttps=" + this.mediaURLHttps + ", expandedURL=" + this.expandedURL + ", displayURL='" + this.displayURL + '\'' + ", sizes=" + this.sizes + ", type=" + this.type + '}';
    }

    static class Size
    implements MediaEntity.Size {
        private static final long serialVersionUID = -2515842281909325169L;
        int width;
        int height;
        int resize;

        Size() {
        }

        Size(JSONObject jSONObject) {
            this.width = jSONObject.getInt("w");
            this.height = jSONObject.getInt("h");
            this.resize = "fit".equals(jSONObject.getString("resize")) ? 100 : 101;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getResize() {
            return this.resize;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Size)) {
                return false;
            }
            Size size = (Size)object;
            if (this.height != size.height) {
                return false;
            }
            if (this.resize != size.resize) {
                return false;
            }
            return this.width == size.width;
        }

        public int hashCode() {
            int n2 = this.width;
            n2 = 31 * n2 + this.height;
            n2 = 31 * n2 + this.resize;
            return n2;
        }

        public String toString() {
            return "Size{width=" + this.width + ", height=" + this.height + ", resize=" + this.resize + '}';
        }
    }
}

