/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.HttpResponse;
import be.maximvdw.featherboardcore.twitter.JSONArray;
import be.maximvdw.featherboardcore.twitter.JSONException;
import be.maximvdw.featherboardcore.twitter.JSONObject;
import be.maximvdw.featherboardcore.twitter.Location;
import be.maximvdw.featherboardcore.twitter.ParseUtil;
import be.maximvdw.featherboardcore.twitter.ResponseList;
import be.maximvdw.featherboardcore.twitter.ResponseListImpl;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import be.maximvdw.featherboardcore.twitter.TwitterObjectFactory;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocationJSONImpl
implements Location {
    private static final long serialVersionUID = -1312752311160422264L;
    private final int woeid;
    private final String countryName;
    private final String countryCode;
    private final String placeName;
    private final int placeCode;
    private final String name;
    private final String url;

    LocationJSONImpl(JSONObject jSONObject) {
        try {
            this.woeid = ParseUtil.getInt("woeid", jSONObject);
            this.countryName = ParseUtil.getUnescapedString("country", jSONObject);
            this.countryCode = ParseUtil.getRawString("countryCode", jSONObject);
            if (!jSONObject.isNull("placeType")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("placeType");
                this.placeName = ParseUtil.getUnescapedString("name", jSONObject2);
                this.placeCode = ParseUtil.getInt("code", jSONObject2);
            } else {
                this.placeName = null;
                this.placeCode = -1;
            }
            this.name = ParseUtil.getUnescapedString("name", jSONObject);
            this.url = ParseUtil.getUnescapedString("url", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    static ResponseList<Location> createLocationList(HttpResponse httpResponse, Configuration configuration) {
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
        }
        return LocationJSONImpl.createLocationList(httpResponse.asJSONArray(), configuration.isJSONStoreEnabled());
    }

    static ResponseList<Location> createLocationList(JSONArray jSONArray, boolean bl2) {
        try {
            int n2 = jSONArray.length();
            ResponseListImpl<Location> responseListImpl = new ResponseListImpl<Location>(n2, null);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                LocationJSONImpl locationJSONImpl = new LocationJSONImpl(jSONObject);
                responseListImpl.add(locationJSONImpl);
                if (!bl2) continue;
                TwitterObjectFactory.registerJSONObject(locationJSONImpl, jSONObject);
            }
            if (bl2) {
                TwitterObjectFactory.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    @Override
    public int getWoeid() {
        return this.woeid;
    }

    @Override
    public String getCountryName() {
        return this.countryName;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getPlaceName() {
        return this.placeName;
    }

    @Override
    public int getPlaceCode() {
        return this.placeCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationJSONImpl)) {
            return false;
        }
        LocationJSONImpl locationJSONImpl = (LocationJSONImpl)object;
        return this.woeid == locationJSONImpl.woeid;
    }

    public int hashCode() {
        return this.woeid;
    }

    public String toString() {
        return "LocationJSONImpl{woeid=" + this.woeid + ", countryName='" + this.countryName + '\'' + ", countryCode='" + this.countryCode + '\'' + ", placeName='" + this.placeName + '\'' + ", placeCode='" + this.placeCode + '\'' + ", name='" + this.name + '\'' + ", url='" + this.url + '\'' + '}';
    }
}

