/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpParameter
implements Serializable,
Comparable<HttpParameter> {
    private static final long serialVersionUID = 4046908449190454692L;
    private String name = null;
    private String value = null;
    private File file = null;
    private InputStream fileBody = null;
    private static final String JPEG = "image/jpeg";
    private static final String GIF = "image/gif";
    private static final String PNG = "image/png";
    private static final String OCTET = "application/octet-stream";

    public HttpParameter(String string, String string2) {
        this.name = string;
        this.value = string2;
    }

    public HttpParameter(String string, File file) {
        this.name = string;
        this.file = file;
    }

    public HttpParameter(String string, String string2, InputStream inputStream) {
        this.name = string;
        this.file = new File(string2);
        this.fileBody = inputStream;
    }

    public HttpParameter(String string, int n2) {
        this.name = string;
        this.value = String.valueOf(n2);
    }

    public HttpParameter(String string, long l2) {
        this.name = string;
        this.value = String.valueOf(l2);
    }

    public HttpParameter(String string, double d2) {
        this.name = string;
        this.value = String.valueOf(d2);
    }

    public HttpParameter(String string, boolean bl2) {
        this.name = string;
        this.value = String.valueOf(bl2);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getFileBody() {
        return this.fileBody;
    }

    public boolean isFile() {
        return this.file != null;
    }

    public boolean hasFileBody() {
        return this.fileBody != null;
    }

    public String getContentType() {
        if (!this.isFile()) {
            throw new IllegalStateException("not a file");
        }
        String string = this.file.getName();
        int n2 = string.lastIndexOf(".");
        String string2 = -1 == n2 ? OCTET : ((string = string.substring(string.lastIndexOf(".") + 1).toLowerCase()).length() == 3 ? ("gif".equals(string) ? GIF : ("png".equals(string) ? PNG : ("jpg".equals(string) ? JPEG : OCTET))) : (string.length() == 4 ? ("jpeg".equals(string) ? JPEG : OCTET) : OCTET));
        return string2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HttpParameter)) {
            return false;
        }
        HttpParameter httpParameter = (HttpParameter)object;
        if (this.file != null ? !this.file.equals(httpParameter.file) : httpParameter.file != null) {
            return false;
        }
        if (this.fileBody != null ? !this.fileBody.equals(httpParameter.fileBody) : httpParameter.fileBody != null) {
            return false;
        }
        if (!this.name.equals(httpParameter.name)) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(httpParameter.value) : httpParameter.value != null);
    }

    public static boolean containsFile(HttpParameter[] httpParameterArray) {
        boolean bl2 = false;
        if (null == httpParameterArray) {
            return false;
        }
        for (HttpParameter httpParameter : httpParameterArray) {
            if (!httpParameter.isFile()) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    static boolean containsFile(List<HttpParameter> list) {
        boolean bl2 = false;
        for (HttpParameter httpParameter : list) {
            if (!httpParameter.isFile()) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public static HttpParameter[] getParameterArray(String string, String string2) {
        return new HttpParameter[]{new HttpParameter(string, string2)};
    }

    public static HttpParameter[] getParameterArray(String string, int n2) {
        return HttpParameter.getParameterArray(string, String.valueOf(n2));
    }

    public static HttpParameter[] getParameterArray(String string, String string2, String string3, String string4) {
        return new HttpParameter[]{new HttpParameter(string, string2), new HttpParameter(string3, string4)};
    }

    public static HttpParameter[] getParameterArray(String string, int n2, String string2, int n3) {
        return HttpParameter.getParameterArray(string, String.valueOf(n2), string2, String.valueOf(n3));
    }

    public int hashCode() {
        int n2 = this.name.hashCode();
        n2 = 31 * n2 + (this.value != null ? this.value.hashCode() : 0);
        n2 = 31 * n2 + (this.file != null ? this.file.hashCode() : 0);
        n2 = 31 * n2 + (this.fileBody != null ? this.fileBody.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "PostParameter{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", file=" + this.file + ", fileBody=" + this.fileBody + '}';
    }

    @Override
    public int compareTo(HttpParameter httpParameter) {
        int n2 = this.name.compareTo(httpParameter.name);
        if (0 == n2) {
            n2 = this.value.compareTo(httpParameter.value);
        }
        return n2;
    }

    public static String encodeParameters(HttpParameter[] httpParameterArray) {
        if (null == httpParameterArray) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < httpParameterArray.length; ++i2) {
            if (httpParameterArray[i2].isFile()) {
                throw new IllegalArgumentException("parameter [" + httpParameterArray[i2].name + "]should be text");
            }
            if (i2 != 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(HttpParameter.encode(httpParameterArray[i2].name)).append("=").append(HttpParameter.encode(httpParameterArray[i2].value));
        }
        return stringBuilder.toString();
    }

    public static String encode(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 == '*') {
                stringBuilder.append("%2A");
                continue;
            }
            if (c2 == '+') {
                stringBuilder.append("%20");
                continue;
            }
            if (c2 == '%' && i2 + 1 < string2.length() && string2.charAt(i2 + 1) == '7' && string2.charAt(i2 + 2) == 'E') {
                stringBuilder.append('~');
                i2 += 2;
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String decode(String string) {
        string = string.replace("%2A", "*");
        string = string.replace("%2a", "*");
        string = string.replace("%20", " ");
        String string2 = null;
        try {
            string2 = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public static List<HttpParameter> decodeParameters(String string) {
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>();
        for (String string2 : string.split("&")) {
            String[] stringArray = string2.split("=", 2);
            if (stringArray.length != 2) continue;
            String string3 = HttpParameter.decode(stringArray[0]);
            String string4 = HttpParameter.decode(stringArray[1]);
            if (string3.equals("") || string4.equals("")) continue;
            arrayList.add(new HttpParameter(string3, string4));
        }
        return arrayList;
    }
}

