/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.HttpClient;
import be.maximvdw.featherboardcore.twitter.HttpClientConfiguration;
import be.maximvdw.featherboardcore.twitter.HttpParameter;
import be.maximvdw.featherboardcore.twitter.HttpRequest;
import be.maximvdw.featherboardcore.twitter.HttpResponse;
import be.maximvdw.featherboardcore.twitter.HttpResponseEvent;
import be.maximvdw.featherboardcore.twitter.HttpResponseListener;
import be.maximvdw.featherboardcore.twitter.Logger;
import be.maximvdw.featherboardcore.twitter.RequestMethod;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import be.maximvdw.featherboardcore.twitter.Version;
import be.maximvdw.featherboardcore.twitter.auth.Authorization;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpClientBase
implements HttpClient,
Serializable {
    private static final Logger logger = Logger.getLogger(HttpClientBase.class);
    private static final long serialVersionUID = -8016974810651763053L;
    protected final HttpClientConfiguration CONF;
    private final Map<String, String> requestHeaders;

    public HttpClientBase(HttpClientConfiguration httpClientConfiguration) {
        this.CONF = httpClientConfiguration;
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("X-Twitter-Client-Version", Version.getVersion());
        this.requestHeaders.put("X-Twitter-Client-URL", "http://twitter4j.org/en/twitter4j-" + Version.getVersion() + ".xml");
        this.requestHeaders.put("X-Twitter-Client", "Twitter4J");
        this.requestHeaders.put("User-Agent", "be/maximvdw/featherboardcore/twitter http://twitter4j.org/ /" + Version.getVersion());
        if (httpClientConfiguration.isGZIPEnabled()) {
            this.requestHeaders.put("Accept-Encoding", "gzip");
        }
    }

    protected boolean isProxyConfigured() {
        return this.CONF.getHttpProxyHost() != null && !this.CONF.getHttpProxyHost().equals("");
    }

    public void write(DataOutputStream dataOutputStream, String string) {
        dataOutputStream.writeBytes(string);
        logger.debug(string);
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public void addDefaultRequestHeader(String string, String string2) {
        this.requestHeaders.put(string, string2);
    }

    @Override
    public final HttpResponse request(HttpRequest httpRequest) {
        return this.handleRequest(httpRequest);
    }

    @Override
    public final HttpResponse request(HttpRequest httpRequest, HttpResponseListener httpResponseListener) {
        try {
            HttpResponse httpResponse = this.handleRequest(httpRequest);
            if (httpResponseListener != null) {
                httpResponseListener.httpResponseReceived(new HttpResponseEvent(httpRequest, httpResponse, null));
            }
            return httpResponse;
        }
        catch (TwitterException twitterException) {
            if (httpResponseListener != null) {
                httpResponseListener.httpResponseReceived(new HttpResponseEvent(httpRequest, null, twitterException));
            }
            throw twitterException;
        }
    }

    abstract HttpResponse handleRequest(HttpRequest var1);

    @Override
    public HttpResponse get(String string, HttpParameter[] httpParameterArray, Authorization authorization, HttpResponseListener httpResponseListener) {
        return this.request(new HttpRequest(RequestMethod.GET, string, httpParameterArray, authorization, this.requestHeaders), httpResponseListener);
    }

    @Override
    public HttpResponse get(String string) {
        return this.request(new HttpRequest(RequestMethod.GET, string, null, null, this.requestHeaders));
    }

    @Override
    public HttpResponse post(String string, HttpParameter[] httpParameterArray, Authorization authorization, HttpResponseListener httpResponseListener) {
        return this.request(new HttpRequest(RequestMethod.POST, string, httpParameterArray, authorization, this.requestHeaders), httpResponseListener);
    }

    @Override
    public HttpResponse post(String string) {
        return this.request(new HttpRequest(RequestMethod.POST, string, null, null, this.requestHeaders));
    }

    @Override
    public HttpResponse delete(String string, HttpParameter[] httpParameterArray, Authorization authorization, HttpResponseListener httpResponseListener) {
        return this.request(new HttpRequest(RequestMethod.DELETE, string, httpParameterArray, authorization, this.requestHeaders), httpResponseListener);
    }

    @Override
    public HttpResponse delete(String string) {
        return this.request(new HttpRequest(RequestMethod.DELETE, string, null, null, this.requestHeaders));
    }

    @Override
    public HttpResponse head(String string) {
        return this.request(new HttpRequest(RequestMethod.HEAD, string, null, null, this.requestHeaders));
    }

    @Override
    public HttpResponse put(String string, HttpParameter[] httpParameterArray, Authorization authorization, HttpResponseListener httpResponseListener) {
        return this.request(new HttpRequest(RequestMethod.PUT, string, httpParameterArray, authorization, this.requestHeaders), httpResponseListener);
    }

    @Override
    public HttpResponse put(String string) {
        return this.request(new HttpRequest(RequestMethod.PUT, string, null, null, this.requestHeaders));
    }
}

