/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.EntityIndex;
import be.maximvdw.featherboardcore.twitter.HashtagEntity;
import be.maximvdw.featherboardcore.twitter.JSONArray;
import be.maximvdw.featherboardcore.twitter.JSONException;
import be.maximvdw.featherboardcore.twitter.JSONObject;
import be.maximvdw.featherboardcore.twitter.SymbolEntity;
import be.maximvdw.featherboardcore.twitter.TwitterException;

class HashtagEntityJSONImpl
extends EntityIndex
implements HashtagEntity,
SymbolEntity {
    private static final long serialVersionUID = -5317828991902848906L;
    private String text;

    HashtagEntityJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    HashtagEntityJSONImpl(int n2, int n3, String string) {
        this.setStart(n2);
        this.setEnd(n3);
        this.text = string;
    }

    HashtagEntityJSONImpl() {
    }

    private void init(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("indices");
            this.setStart(jSONArray.getInt(0));
            this.setEnd(jSONArray.getInt(1));
            if (!jSONObject.isNull("text")) {
                this.text = jSONObject.getString("text");
            }
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public String getText() {
        return this.text;
    }

    public int getStart() {
        return super.getStart();
    }

    public int getEnd() {
        return super.getEnd();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HashtagEntityJSONImpl hashtagEntityJSONImpl = (HashtagEntityJSONImpl)object;
        return !(this.text != null ? !this.text.equals(hashtagEntityJSONImpl.text) : hashtagEntityJSONImpl.text != null);
    }

    public int hashCode() {
        return this.text != null ? this.text.hashCode() : 0;
    }

    public String toString() {
        return "HashtagEntityJSONImpl{text='" + this.text + '\'' + '}';
    }
}

