/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.GeoLocation;
import be.maximvdw.featherboardcore.twitter.HttpParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeoQuery
implements Serializable {
    private static final long serialVersionUID = 5434503339001056634L;
    private GeoLocation location;
    private String query = null;
    private String ip = null;
    private String accuracy = null;
    private String granularity = null;
    private int maxResults = -1;

    public GeoQuery(GeoLocation geoLocation) {
        this.location = geoLocation;
    }

    public GeoQuery(String string) {
        this.ip = string;
    }

    public GeoLocation getLocation() {
        return this.location;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public String getIp() {
        return this.ip;
    }

    public String getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(String string) {
        this.accuracy = string;
    }

    public GeoQuery accuracy(String string) {
        this.setAccuracy(string);
        return this;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public void setGranularity(String string) {
        this.granularity = string;
    }

    public GeoQuery granularity(String string) {
        this.setGranularity(string);
        return this;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int n2) {
        this.maxResults = n2;
    }

    public GeoQuery maxResults(int n2) {
        this.setMaxResults(n2);
        return this;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>();
        if (this.location != null) {
            this.appendParameter("lat", this.location.getLatitude(), arrayList);
            this.appendParameter("long", this.location.getLongitude(), arrayList);
        }
        if (this.ip != null) {
            this.appendParameter("ip", this.ip, arrayList);
        }
        this.appendParameter("accuracy", this.accuracy, arrayList);
        this.appendParameter("query", this.query, arrayList);
        this.appendParameter("granularity", this.granularity, arrayList);
        this.appendParameter("max_results", this.maxResults, (List<HttpParameter>)arrayList);
        HttpParameter[] httpParameterArray = new HttpParameter[arrayList.size()];
        return arrayList.toArray(httpParameterArray);
    }

    private void appendParameter(String string, String string2, List<HttpParameter> list) {
        if (string2 != null) {
            list.add(new HttpParameter(string, string2));
        }
    }

    private void appendParameter(String string, int n2, List<HttpParameter> list) {
        if (0 < n2) {
            list.add(new HttpParameter(string, String.valueOf(n2)));
        }
    }

    private void appendParameter(String string, double d2, List<HttpParameter> list) {
        list.add(new HttpParameter(string, String.valueOf(d2)));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GeoQuery geoQuery = (GeoQuery)object;
        if (this.maxResults != geoQuery.maxResults) {
            return false;
        }
        if (this.accuracy != null ? !this.accuracy.equals(geoQuery.accuracy) : geoQuery.accuracy != null) {
            return false;
        }
        if (this.granularity != null ? !this.granularity.equals(geoQuery.granularity) : geoQuery.granularity != null) {
            return false;
        }
        if (this.ip != null ? !this.ip.equals(geoQuery.ip) : geoQuery.ip != null) {
            return false;
        }
        return !(this.location != null ? !this.location.equals(geoQuery.location) : geoQuery.location != null);
    }

    public int hashCode() {
        int n2 = this.location != null ? this.location.hashCode() : 0;
        n2 = 31 * n2 + (this.ip != null ? this.ip.hashCode() : 0);
        n2 = 31 * n2 + (this.accuracy != null ? this.accuracy.hashCode() : 0);
        n2 = 31 * n2 + (this.granularity != null ? this.granularity.hashCode() : 0);
        n2 = 31 * n2 + this.maxResults;
        return n2;
    }

    public String toString() {
        return "GeoQuery{location=" + this.location + ", query='" + this.query + '\'' + ", ip='" + this.ip + '\'' + ", accuracy='" + this.accuracy + '\'' + ", granularity='" + this.granularity + '\'' + ", maxResults=" + this.maxResults + '}';
    }
}

