/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.Friendship;
import be.maximvdw.featherboardcore.twitter.HttpResponse;
import be.maximvdw.featherboardcore.twitter.JSONArray;
import be.maximvdw.featherboardcore.twitter.JSONException;
import be.maximvdw.featherboardcore.twitter.JSONObject;
import be.maximvdw.featherboardcore.twitter.ParseUtil;
import be.maximvdw.featherboardcore.twitter.ResponseList;
import be.maximvdw.featherboardcore.twitter.ResponseListImpl;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import be.maximvdw.featherboardcore.twitter.TwitterObjectFactory;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FriendshipJSONImpl
implements Friendship {
    private static final long serialVersionUID = 6847273186993125826L;
    private final long id;
    private final String name;
    private final String screenName;
    private boolean following = false;
    private boolean followedBy = false;

    FriendshipJSONImpl(JSONObject jSONObject) {
        try {
            this.id = ParseUtil.getLong("id", jSONObject);
            this.name = jSONObject.getString("name");
            this.screenName = jSONObject.getString("screen_name");
            JSONArray jSONArray = jSONObject.getJSONArray("connections");
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                String string = jSONArray.getString(i2);
                if ("following".equals(string)) {
                    this.following = true;
                    continue;
                }
                if (!"followed_by".equals(string)) continue;
                this.followedBy = true;
            }
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    static ResponseList<Friendship> createFriendshipList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
            }
            JSONArray jSONArray = httpResponse.asJSONArray();
            int n2 = jSONArray.length();
            ResponseListImpl<Friendship> responseListImpl = new ResponseListImpl<Friendship>(n2, httpResponse);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                FriendshipJSONImpl friendshipJSONImpl = new FriendshipJSONImpl(jSONObject);
                if (configuration.isJSONStoreEnabled()) {
                    TwitterObjectFactory.registerJSONObject(friendshipJSONImpl, jSONObject);
                }
                responseListImpl.add(friendshipJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScreenName() {
        return this.screenName;
    }

    @Override
    public boolean isFollowing() {
        return this.following;
    }

    @Override
    public boolean isFollowedBy() {
        return this.followedBy;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FriendshipJSONImpl friendshipJSONImpl = (FriendshipJSONImpl)object;
        if (this.followedBy != friendshipJSONImpl.followedBy) {
            return false;
        }
        if (this.following != friendshipJSONImpl.following) {
            return false;
        }
        if (this.id != friendshipJSONImpl.id) {
            return false;
        }
        if (!this.name.equals(friendshipJSONImpl.name)) {
            return false;
        }
        return this.screenName.equals(friendshipJSONImpl.screenName);
    }

    public int hashCode() {
        int n2 = (int)(this.id ^ this.id >>> 32);
        n2 = 31 * n2 + (this.name != null ? this.name.hashCode() : 0);
        n2 = 31 * n2 + (this.screenName != null ? this.screenName.hashCode() : 0);
        n2 = 31 * n2 + (this.following ? 1 : 0);
        n2 = 31 * n2 + (this.followedBy ? 1 : 0);
        return n2;
    }

    public String toString() {
        return "FriendshipJSONImpl{id=" + this.id + ", name='" + this.name + '\'' + ", screenName='" + this.screenName + '\'' + ", following=" + this.following + ", followedBy=" + this.followedBy + '}';
    }
}

