/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.Dispatcher;
import be.maximvdw.featherboardcore.twitter.Logger;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

final class DispatcherImpl
implements Dispatcher {
    private final ExecutorService executorService;
    private static final Logger logger = Logger.getLogger(DispatcherImpl.class);
    private static final long SHUTDOWN_TIME = 5000L;

    public DispatcherImpl(final Configuration configuration) {
        this.executorService = Executors.newFixedThreadPool(configuration.getAsyncNumThreads(), new ThreadFactory(){
            int count = 0;

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName(String.format("Twitter4J Async Dispatcher[%d]", this.count++));
                thread.setDaemon(configuration.isDaemonEnabled());
                return thread;
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                DispatcherImpl.this.executorService.shutdown();
            }
        });
    }

    public synchronized void invokeLater(Runnable runnable) {
        this.executorService.execute(runnable);
    }

    public synchronized void shutdown() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            logger.warn(interruptedException.getMessage());
        }
    }
}

