/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.DirectMessage;
import be.maximvdw.featherboardcore.twitter.ExtendedMediaEntity;
import be.maximvdw.featherboardcore.twitter.HTMLEntity;
import be.maximvdw.featherboardcore.twitter.HashtagEntity;
import be.maximvdw.featherboardcore.twitter.HashtagEntityJSONImpl;
import be.maximvdw.featherboardcore.twitter.HttpResponse;
import be.maximvdw.featherboardcore.twitter.JSONArray;
import be.maximvdw.featherboardcore.twitter.JSONException;
import be.maximvdw.featherboardcore.twitter.JSONObject;
import be.maximvdw.featherboardcore.twitter.MediaEntity;
import be.maximvdw.featherboardcore.twitter.MediaEntityJSONImpl;
import be.maximvdw.featherboardcore.twitter.ParseUtil;
import be.maximvdw.featherboardcore.twitter.ResponseList;
import be.maximvdw.featherboardcore.twitter.ResponseListImpl;
import be.maximvdw.featherboardcore.twitter.SymbolEntity;
import be.maximvdw.featherboardcore.twitter.TwitterException;
import be.maximvdw.featherboardcore.twitter.TwitterObjectFactory;
import be.maximvdw.featherboardcore.twitter.TwitterResponseImpl;
import be.maximvdw.featherboardcore.twitter.URLEntity;
import be.maximvdw.featherboardcore.twitter.URLEntityJSONImpl;
import be.maximvdw.featherboardcore.twitter.User;
import be.maximvdw.featherboardcore.twitter.UserJSONImpl;
import be.maximvdw.featherboardcore.twitter.UserMentionEntity;
import be.maximvdw.featherboardcore.twitter.UserMentionEntityJSONImpl;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DirectMessageJSONImpl
extends TwitterResponseImpl
implements DirectMessage,
Serializable {
    private static final long serialVersionUID = 7092906238192790921L;
    private long id;
    private String text;
    private long senderId;
    private long recipientId;
    private Date createdAt;
    private String senderScreenName;
    private String recipientScreenName;
    private UserMentionEntity[] userMentionEntities;
    private URLEntity[] urlEntities;
    private HashtagEntity[] hashtagEntities;
    private MediaEntity[] mediaEntities;
    private ExtendedMediaEntity[] extendedMediaEntities;
    private SymbolEntity[] symbolEntities;
    private User sender;
    private User recipient;

    DirectMessageJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, jSONObject);
        }
    }

    DirectMessageJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        this.id = ParseUtil.getLong("id", jSONObject);
        this.senderId = ParseUtil.getLong("sender_id", jSONObject);
        this.recipientId = ParseUtil.getLong("recipient_id", jSONObject);
        this.createdAt = ParseUtil.getDate("created_at", jSONObject);
        this.senderScreenName = ParseUtil.getUnescapedString("sender_screen_name", jSONObject);
        this.recipientScreenName = ParseUtil.getUnescapedString("recipient_screen_name", jSONObject);
        try {
            this.sender = new UserJSONImpl(jSONObject.getJSONObject("sender"));
            this.recipient = new UserJSONImpl(jSONObject.getJSONObject("recipient"));
            if (!jSONObject.isNull("entities")) {
                int n2;
                int n3;
                JSONArray jSONArray;
                JSONObject jSONObject2 = jSONObject.getJSONObject("entities");
                if (!jSONObject2.isNull("user_mentions")) {
                    jSONArray = jSONObject2.getJSONArray("user_mentions");
                    n3 = jSONArray.length();
                    this.userMentionEntities = new UserMentionEntity[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.userMentionEntities[n2] = new UserMentionEntityJSONImpl(jSONArray.getJSONObject(n2));
                    }
                }
                if (!jSONObject2.isNull("urls")) {
                    jSONArray = jSONObject2.getJSONArray("urls");
                    n3 = jSONArray.length();
                    this.urlEntities = new URLEntity[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.urlEntities[n2] = new URLEntityJSONImpl(jSONArray.getJSONObject(n2));
                    }
                }
                if (!jSONObject2.isNull("hashtags")) {
                    jSONArray = jSONObject2.getJSONArray("hashtags");
                    n3 = jSONArray.length();
                    this.hashtagEntities = new HashtagEntity[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.hashtagEntities[n2] = new HashtagEntityJSONImpl(jSONArray.getJSONObject(n2));
                    }
                }
                if (!jSONObject2.isNull("symbols")) {
                    jSONArray = jSONObject2.getJSONArray("symbols");
                    n3 = jSONArray.length();
                    this.symbolEntities = new SymbolEntity[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.symbolEntities[n2] = new HashtagEntityJSONImpl(jSONArray.getJSONObject(n2));
                    }
                }
                if (!jSONObject2.isNull("media")) {
                    jSONArray = jSONObject2.getJSONArray("media");
                    n3 = jSONArray.length();
                    this.mediaEntities = new MediaEntity[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.mediaEntities[n2] = new MediaEntityJSONImpl(jSONArray.getJSONObject(n2));
                    }
                }
            }
            this.userMentionEntities = this.userMentionEntities == null ? new UserMentionEntity[]{} : this.userMentionEntities;
            this.urlEntities = this.urlEntities == null ? new URLEntity[]{} : this.urlEntities;
            this.hashtagEntities = this.hashtagEntities == null ? new HashtagEntity[]{} : this.hashtagEntities;
            this.symbolEntities = this.symbolEntities == null ? new SymbolEntity[]{} : this.symbolEntities;
            this.mediaEntities = this.mediaEntities == null ? new MediaEntity[]{} : this.mediaEntities;
            this.extendedMediaEntities = this.extendedMediaEntities == null ? new ExtendedMediaEntity[]{} : this.extendedMediaEntities;
            this.text = HTMLEntity.unescapeAndSlideEntityIncdices(jSONObject.getString("text"), this.userMentionEntities, this.urlEntities, this.hashtagEntities, this.mediaEntities);
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public long getSenderId() {
        return this.senderId;
    }

    @Override
    public long getRecipientId() {
        return this.recipientId;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getSenderScreenName() {
        return this.senderScreenName;
    }

    @Override
    public String getRecipientScreenName() {
        return this.recipientScreenName;
    }

    @Override
    public User getSender() {
        return this.sender;
    }

    @Override
    public User getRecipient() {
        return this.recipient;
    }

    @Override
    public UserMentionEntity[] getUserMentionEntities() {
        return this.userMentionEntities;
    }

    @Override
    public URLEntity[] getURLEntities() {
        return this.urlEntities;
    }

    @Override
    public HashtagEntity[] getHashtagEntities() {
        return this.hashtagEntities;
    }

    @Override
    public MediaEntity[] getMediaEntities() {
        return this.mediaEntities;
    }

    @Override
    public ExtendedMediaEntity[] getExtendedMediaEntities() {
        return this.extendedMediaEntities;
    }

    @Override
    public SymbolEntity[] getSymbolEntities() {
        return this.symbolEntities;
    }

    static ResponseList<DirectMessage> createDirectMessageList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
            }
            JSONArray jSONArray = httpResponse.asJSONArray();
            int n2 = jSONArray.length();
            ResponseListImpl<DirectMessage> responseListImpl = new ResponseListImpl<DirectMessage>(n2, httpResponse);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                DirectMessageJSONImpl directMessageJSONImpl = new DirectMessageJSONImpl(jSONObject);
                responseListImpl.add(directMessageJSONImpl);
                if (!configuration.isJSONStoreEnabled()) continue;
                TwitterObjectFactory.registerJSONObject(directMessageJSONImpl, jSONObject);
            }
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return object instanceof DirectMessage && ((DirectMessage)object).getId() == this.id;
    }

    public String toString() {
        return "DirectMessageJSONImpl{id=" + this.id + ", text='" + this.text + '\'' + ", sender_id=" + this.senderId + ", recipient_id=" + this.recipientId + ", created_at=" + this.createdAt + ", userMentionEntities=" + (this.userMentionEntities == null ? null : Arrays.asList(this.userMentionEntities)) + ", urlEntities=" + (this.urlEntities == null ? null : Arrays.asList(this.urlEntities)) + ", hashtagEntities=" + (this.hashtagEntities == null ? null : Arrays.asList(this.hashtagEntities)) + ", sender_screen_name='" + this.senderScreenName + '\'' + ", recipient_screen_name='" + this.recipientScreenName + '\'' + ", sender=" + this.sender + ", recipient=" + this.recipient + ", userMentionEntities=" + (this.userMentionEntities == null ? null : Arrays.asList(this.userMentionEntities)) + ", urlEntities=" + (this.urlEntities == null ? null : Arrays.asList(this.urlEntities)) + ", hashtagEntities=" + (this.hashtagEntities == null ? null : Arrays.asList(this.hashtagEntities)) + '}';
    }
}

