/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.AccountTotals;
import be.maximvdw.featherboardcore.twitter.HttpResponse;
import be.maximvdw.featherboardcore.twitter.JSONObject;
import be.maximvdw.featherboardcore.twitter.ParseUtil;
import be.maximvdw.featherboardcore.twitter.TwitterObjectFactory;
import be.maximvdw.featherboardcore.twitter.TwitterResponseImpl;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;
import java.io.Serializable;

class AccountTotalsJSONImpl
extends TwitterResponseImpl
implements AccountTotals,
Serializable {
    private static final long serialVersionUID = 4199733699237229892L;
    private final int updates;
    private final int followers;
    private final int favorites;
    private final int friends;

    private AccountTotalsJSONImpl(HttpResponse httpResponse, JSONObject jSONObject) {
        super(httpResponse);
        this.updates = ParseUtil.getInt("updates", jSONObject);
        this.followers = ParseUtil.getInt("followers", jSONObject);
        this.favorites = ParseUtil.getInt("favorites", jSONObject);
        this.friends = ParseUtil.getInt("friends", jSONObject);
    }

    AccountTotalsJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        this(httpResponse, httpResponse.asJSONObject());
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, httpResponse.asJSONObject());
        }
    }

    AccountTotalsJSONImpl(JSONObject jSONObject) {
        this(null, jSONObject);
    }

    public int getUpdates() {
        return this.updates;
    }

    public int getFollowers() {
        return this.followers;
    }

    public int getFavorites() {
        return this.favorites;
    }

    public int getFriends() {
        return this.friends;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AccountTotalsJSONImpl accountTotalsJSONImpl = (AccountTotalsJSONImpl)object;
        if (this.favorites != accountTotalsJSONImpl.favorites) {
            return false;
        }
        if (this.followers != accountTotalsJSONImpl.followers) {
            return false;
        }
        if (this.friends != accountTotalsJSONImpl.friends) {
            return false;
        }
        return this.updates == accountTotalsJSONImpl.updates;
    }

    public int hashCode() {
        int n2 = this.updates;
        n2 = 31 * n2 + this.followers;
        n2 = 31 * n2 + this.favorites;
        n2 = 31 * n2 + this.friends;
        return n2;
    }

    public String toString() {
        return "AccountTotalsJSONImpl{updates=" + this.updates + ", followers=" + this.followers + ", favorites=" + this.favorites + ", friends=" + this.friends + '}';
    }
}

