/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.util;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class z_F4JInternalParseUtil {
    private static final String ISO8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String ISO8601_DATE_FORMAT_WITHOUT_TZ = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String ISO8601_DATE_FORMAT_WITHOUT_TIME = "yyyy-MM-dd";

    private z_F4JInternalParseUtil() {
        throw new AssertionError();
    }

    public static String getRawString(String string, JSONObject jSONObject) {
        try {
            if (jSONObject.isNull(string)) {
                return null;
            }
            return jSONObject.getString(string);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static int getPrimitiveInt(String string, JSONObject jSONObject) {
        return z_F4JInternalParseUtil.getPrimitiveInt(z_F4JInternalParseUtil.getRawString(string, jSONObject));
    }

    public static int getPrimitiveInt(String string) {
        if (null == string || "".equals(string) || "null".equals(string)) {
            return -1;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static Integer getInt(String string, JSONObject jSONObject) {
        return z_F4JInternalParseUtil.getInt(z_F4JInternalParseUtil.getRawString(string, jSONObject));
    }

    public static Integer getInt(String string) {
        if (null == string || "".equals(string) || "null".equals(string)) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static long getPrimitiveLong(String string, JSONObject jSONObject) {
        return z_F4JInternalParseUtil.getPrimitiveLong(z_F4JInternalParseUtil.getRawString(string, jSONObject));
    }

    public static long getPrimitiveLong(String string) {
        if (null == string || "".equals(string) || "null".equals(string)) {
            return -1L;
        }
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static Long getLong(String string, JSONObject jSONObject) {
        return z_F4JInternalParseUtil.getLong(z_F4JInternalParseUtil.getRawString(string, jSONObject));
    }

    public static Long getLong(String string) {
        if (null == string || "".equals(string) || "null".equals(string)) {
            return null;
        }
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Double getDouble(String string, JSONObject jSONObject) {
        String string2 = z_F4JInternalParseUtil.getRawString(string, jSONObject);
        if (null == string2 || "".equals(string2) || "null".equals(string2)) {
            return null;
        }
        return Double.valueOf(string2);
    }

    public static Double getTimeZoneOffset(String string, JSONObject jSONObject, long l2) {
        String string2 = z_F4JInternalParseUtil.getRawString(string, jSONObject);
        if (null == string2 || "".equals(string2) || "null".equals(string2)) {
            return null;
        }
        try {
            return Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            TimeZone timeZone = TimeZone.getTimeZone(string2);
            return Integer.valueOf(z_F4JInternalParseUtil.computeTimeZoneOffsetInHours(timeZone, l2)).doubleValue();
        }
    }

    public static int computeTimeZoneOffsetInHours(TimeZone timeZone, long l2) {
        int n2 = timeZone.getOffset(l2);
        return n2 / 3600000;
    }

    public static Boolean getBoolean(String string, JSONObject jSONObject) {
        String string2 = z_F4JInternalParseUtil.getRawString(string, jSONObject);
        if (null == string2 || "null".equals(string2)) {
            return null;
        }
        return Boolean.valueOf(string2);
    }

    public static boolean getFlag(String string, JSONObject jSONObject) {
        int n2 = z_F4JInternalParseUtil.getPrimitiveInt(string, jSONObject);
        return n2 == 1;
    }

    public static Date getISO8601Datetime(String string, JSONObject jSONObject) {
        String string2 = z_F4JInternalParseUtil.getRawString(string, jSONObject);
        if (string2 == null) {
            return null;
        }
        if (jSONObject.isNull("timezone")) {
            return z_F4JInternalParseUtil.parseISO8601Date(string2);
        }
        TimeZone timeZone = z_F4JInternalParseUtil.getTimeZone("timezone", jSONObject);
        return z_F4JInternalParseUtil.parseISO8601Date(string2, timeZone);
    }

    private static Date parseISO8601Date(String string) {
        return z_F4JInternalParseUtil.parseISO8601Date(string, TimeZone.getTimeZone("UTC"));
    }

    private static Date parseISO8601Date(String string, TimeZone timeZone) {
        try {
            return new SimpleDateFormat(ISO8601_DATE_FORMAT).parse(string);
        }
        catch (ParseException parseException) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO8601_DATE_FORMAT_WITHOUT_TZ);
                simpleDateFormat.setTimeZone(timeZone);
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException2) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO8601_DATE_FORMAT_WITHOUT_TIME);
                    simpleDateFormat.setTimeZone(timeZone);
                    return simpleDateFormat.parse(string);
                }
                catch (ParseException parseException3) {
                    return null;
                }
            }
        }
    }

    public static URL getURL(String string, JSONObject jSONObject) {
        if (jSONObject.isNull(string)) {
            return null;
        }
        try {
            return new URL(z_F4JInternalParseUtil.getRawString(string, jSONObject));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URI getURI(String string, JSONObject jSONObject) {
        if (jSONObject.isNull(string)) {
            return null;
        }
        try {
            return new URI(z_F4JInternalParseUtil.getRawString(string, jSONObject));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static TimeZone getTimeZone(String string, JSONObject jSONObject) {
        if (jSONObject.isNull(string)) {
            return null;
        }
        return TimeZone.getTimeZone(z_F4JInternalParseUtil.getRawString(string, jSONObject));
    }

    public static Map<String, String> getStringMap(String string, JSONObject jSONObject) {
        if (jSONObject.isNull(string)) {
            return Collections.emptyMap();
        }
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                hashMap.put(string2, jSONObject2.getString(string2));
            }
            return hashMap;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    public static Map<String, Long> getLongMap(String string, JSONObject jSONObject) {
        if (jSONObject.isNull(string)) {
            return Collections.emptyMap();
        }
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string);
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                hashMap.put(string2, jSONObject2.getLong(string2));
            }
            return hashMap;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    public static Map<String, Boolean> getBooleanMap(String string, JSONObject jSONObject) {
        if (jSONObject.isNull(string)) {
            return Collections.emptyMap();
        }
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string);
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                hashMap.put(string2, jSONObject2.getBoolean(string2));
            }
            return hashMap;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    public static List<String> getStringList(String string, JSONObject jSONObject) {
        if (jSONObject.isNull(string)) {
            return Collections.emptyList();
        }
        try {
            JSONArray jSONArray = jSONObject.getJSONArray(string);
            int n2 = jSONArray.length();
            ArrayList<String> arrayList = new ArrayList<String>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(jSONArray.getString(i2));
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    public static boolean isJSONObject(String string, JSONObject jSONObject) {
        try {
            Object object = jSONObject.get(string);
            return object instanceof JSONObject;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public static boolean isJSONArray(String string, JSONObject jSONObject) {
        try {
            Object object = jSONObject.get(string);
            return object instanceof JSONArray;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }
}

