/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.Picture;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.TaggableFriend;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.PictureJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TaggableFriendJSONImpl
extends FacebookResponseImpl
implements TaggableFriend,
Serializable {
    private static final long serialVersionUID = 181026591648082420L;
    private String token;
    private String name;
    private Picture picture;

    TaggableFriendJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    TaggableFriendJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            this.token = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
            if (!jSONObject.isNull("picture")) {
                String string = z_F4JInternalParseUtil.getRawString("picture", jSONObject);
                if (string.startsWith("{")) {
                    JSONObject jSONObject2 = jSONObject.getJSONObject("picture");
                    this.picture = new PictureJSONImpl(jSONObject2);
                } else {
                    this.picture = new PictureJSONImpl(z_F4JInternalParseUtil.getURL("picture", jSONObject));
                }
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Picture getPicture() {
        return this.picture;
    }

    static ResponseList<TaggableFriend> createTaggableFriendList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<TaggableFriend> responseListImpl = new ResponseListImpl<TaggableFriend>(n2, jSONObject, new TaggableFriend[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                TaggableFriendJSONImpl taggableFriendJSONImpl = new TaggableFriendJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(taggableFriendJSONImpl, jSONObject2);
                }
                responseListImpl.add(taggableFriendJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TaggableFriendJSONImpl)) {
            return false;
        }
        return object instanceof TaggableFriend && ((TaggableFriend)object).getToken().equals(this.token);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.token == null ? 0 : this.token.hashCode());
        return n3;
    }

    public String toString() {
        return "TaggableFriendJSONImpl{id=" + this.token + "name=" + this.name + ", picture=" + this.picture + '}';
    }
}

