/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.IdNameEntity;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.Tab;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TabJSONImpl
extends FacebookResponseImpl
implements Tab,
Serializable {
    private static final long serialVersionUID = -7967769244971110725L;
    private String id;
    private String name;
    private URL link;
    private IdNameEntity application;
    private String customName;
    private Boolean isPermanent;
    private Integer position;
    private Boolean isNonConnectionLandingTab;
    private URL imageURL;
    private URL customImageURL;

    TabJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    TabJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
            this.link = z_F4JInternalParseUtil.getURL("link", jSONObject);
            if (!jSONObject.isNull("application")) {
                this.application = new IdNameEntityJSONImpl(jSONObject.getJSONObject("application"));
            }
            this.customName = z_F4JInternalParseUtil.getRawString("custom_name", jSONObject);
            this.isPermanent = z_F4JInternalParseUtil.getBoolean("is_permanent", jSONObject);
            this.position = z_F4JInternalParseUtil.getInt("position", jSONObject);
            this.isNonConnectionLandingTab = z_F4JInternalParseUtil.getBoolean("is_non_connection_landing_tab", jSONObject);
            this.imageURL = z_F4JInternalParseUtil.getURL("image_url", jSONObject);
            this.customImageURL = z_F4JInternalParseUtil.getURL("custom_image_url", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public IdNameEntity getApplication() {
        return this.application;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public Boolean isPermanent() {
        return this.isPermanent;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public Boolean isNonConnectionLandingTab() {
        return this.isNonConnectionLandingTab;
    }

    @Override
    public URL getImageURL() {
        return this.imageURL;
    }

    @Override
    public URL getCustomImageURL() {
        return this.customImageURL;
    }

    static ResponseList<Tab> createTabList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Tab> responseListImpl = new ResponseListImpl<Tab>(n2, jSONObject, new Tab[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                TabJSONImpl tabJSONImpl = new TabJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(tabJSONImpl, jSONObject2);
                }
                responseListImpl.add(tabJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TabJSONImpl)) {
            return false;
        }
        TabJSONImpl tabJSONImpl = (TabJSONImpl)object;
        return !(this.id != null ? !this.id.equals(tabJSONImpl.id) : tabJSONImpl.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "TabJSONImpl{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", link=" + this.link + ", application=" + this.application + ", customName='" + this.customName + '\'' + ", isPermanent=" + this.isPermanent + ", position=" + this.position + ", isNonConnectionLandingTab=" + this.isNonConnectionLandingTab + ", imageURL=" + this.imageURL + ", customImageURL=" + this.customImageURL + '}';
    }
}

