/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.IdNameEntity;
import be.maximvdw.featherboardcore.facebook.PagableList;
import be.maximvdw.featherboardcore.facebook.QuestionVotes;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.PagableListImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QuestionVotesJSONImpl
extends FacebookResponseImpl
implements QuestionVotes,
Serializable {
    private static final long serialVersionUID = -1051921085759549828L;
    private String id;
    private PagableList<IdNameEntity> votes;

    QuestionVotesJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    QuestionVotesJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("votes")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("votes");
                JSONArray jSONArray = jSONObject2.getJSONArray("data");
                int n2 = jSONArray.length();
                this.votes = new PagableListImpl<IdNameEntity>(n2, jSONObject2, new IdNameEntity[0]);
                for (int i2 = 0; i2 < n2; ++i2) {
                    IdNameEntityJSONImpl idNameEntityJSONImpl = new IdNameEntityJSONImpl(jSONArray.getJSONObject(i2));
                    this.votes.add(idNameEntityJSONImpl);
                }
            } else {
                this.votes = new PagableListImpl<IdNameEntity>(0);
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public PagableList<IdNameEntity> getVotes() {
        return this.votes;
    }

    static ResponseList<QuestionVotes> createQuestionVotesList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<QuestionVotes> responseListImpl = new ResponseListImpl<QuestionVotes>(n2, jSONObject, new QuestionVotes[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                QuestionVotesJSONImpl questionVotesJSONImpl = new QuestionVotesJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(questionVotesJSONImpl, jSONObject2);
                }
                responseListImpl.add(questionVotesJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QuestionVotesJSONImpl questionVotesJSONImpl = (QuestionVotesJSONImpl)object;
        return !(this.id == null ? questionVotesJSONImpl.id != null : !this.id.equals(questionVotesJSONImpl.id));
    }

    public String toString() {
        return "QuestionVotesJSONImpl [id=" + this.id + ", votes=" + this.votes + "]";
    }
}

