/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.Category;
import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.PagableList;
import be.maximvdw.featherboardcore.facebook.Question;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.CategoryJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.PagableListImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QuestionJSONImpl
extends FacebookResponseImpl
implements Question,
Serializable {
    private static final long serialVersionUID = 1143276967891229953L;
    private String id;
    private Category from;
    private String question;
    private Date createdTime;
    private Date updatedTime;
    private PagableList<Question.Option> options;

    QuestionJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    QuestionJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                jSONObject2 = jSONObject.getJSONObject("from");
                this.from = new CategoryJSONImpl(jSONObject2);
            }
            this.question = z_F4JInternalParseUtil.getRawString("question", jSONObject);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
            if (!jSONObject.isNull("options")) {
                jSONObject2 = jSONObject.getJSONObject("options");
                this.options = QuestionJSONImpl.createOptionList(jSONObject2);
            } else {
                this.options = new PagableListImpl<Question.Option>(0);
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public String getQuestion() {
        return this.question;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public PagableList<Question.Option> getOptions() {
        return this.options;
    }

    static ResponseList<Question> createQuestionList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Question> responseListImpl = new ResponseListImpl<Question>(n2, jSONObject, new Question[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                QuestionJSONImpl questionJSONImpl = new QuestionJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(questionJSONImpl, jSONObject2);
                }
                responseListImpl.add(questionJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QuestionJSONImpl questionJSONImpl = (QuestionJSONImpl)object;
        return !(this.id == null ? questionJSONImpl.id != null : !this.id.equals(questionJSONImpl.id));
    }

    public String toString() {
        return "QuestionJSONImpl [id=" + this.id + ", from=" + this.from + ", question=" + this.question + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", options=" + this.options + "]";
    }

    static PagableList<Question.Option> createOptionList(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            PagableListImpl<Question.Option> pagableListImpl = new PagableListImpl<Question.Option>(n2, jSONObject, new Question.Option[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                OptionJSONImpl optionJSONImpl = new OptionJSONImpl(jSONArray.getJSONObject(i2));
                pagableListImpl.add(optionJSONImpl);
            }
            return pagableListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    static ResponseList<Question.Option> createOptionList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Question.Option> responseListImpl = new ResponseListImpl<Question.Option>(n2, jSONObject, new Question.Option[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                OptionJSONImpl optionJSONImpl = new OptionJSONImpl(jSONArray.getJSONObject(i2));
                responseListImpl.add(optionJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONObject);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    static class OptionJSONImpl
    implements Question.Option,
    Serializable {
        private static final long serialVersionUID = -6022359823763655064L;
        private String id;
        private Category from;
        private String name;
        private Integer voteCount;
        private Date createdTime;
        private Integer votes;

        OptionJSONImpl(JSONObject jSONObject) {
            try {
                this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
                if (!jSONObject.isNull("from")) {
                    JSONObject jSONObject2 = jSONObject.getJSONObject("from");
                    this.from = new CategoryJSONImpl(jSONObject2);
                }
                this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
                this.voteCount = z_F4JInternalParseUtil.getPrimitiveInt("vote_count", jSONObject);
                this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
                this.votes = z_F4JInternalParseUtil.getPrimitiveInt("votes", jSONObject);
            }
            catch (JSONException jSONException) {
                throw new FacebookException(jSONException.getMessage(), jSONException);
            }
        }

        public String getId() {
            return this.id;
        }

        public Category getFrom() {
            return this.from;
        }

        public String getName() {
            return this.name;
        }

        public Integer getVoteCount() {
            return this.voteCount;
        }

        public Date getCreatedTime() {
            return this.createdTime;
        }

        public Integer getVotes() {
            return this.votes;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            OptionJSONImpl optionJSONImpl = (OptionJSONImpl)object;
            return !(this.id == null ? optionJSONImpl.id != null : !this.id.equals(optionJSONImpl.id));
        }

        public String toString() {
            return "OptionJSONImpl [id=" + this.id + ", from=" + this.from + ", name=" + this.name + ", voteCount=" + this.voteCount + ", createdTime=" + this.createdTime + ", votes=" + this.votes + "]";
        }
    }
}

