/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.IdNameEntity;
import be.maximvdw.featherboardcore.facebook.Poke;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PokeJSONImpl
extends FacebookResponseImpl
implements Poke,
Serializable {
    private static final long serialVersionUID = -4818439169873945111L;
    private IdNameEntity to;
    private IdNameEntity from;
    private Date createdTime;

    PokeJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    PokeJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2;
            if (!jSONObject.isNull("from")) {
                jSONObject2 = jSONObject.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(jSONObject2);
            }
            if (!jSONObject.isNull("to")) {
                jSONObject2 = jSONObject.getJSONObject("to");
                this.to = new IdNameEntityJSONImpl(jSONObject2);
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public IdNameEntity getTo() {
        return this.to;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    static ResponseList<Poke> createPokeList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Poke> responseListImpl = new ResponseListImpl<Poke>(n2, jSONObject, new Poke[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                PokeJSONImpl pokeJSONImpl = new PokeJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(pokeJSONImpl, jSONObject2);
                }
                responseListImpl.add(pokeJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.createdTime == null ? 0 : this.createdTime.hashCode());
        n3 = 31 * n3 + (this.from == null ? 0 : this.from.hashCode());
        n3 = 31 * n3 + (this.to == null ? 0 : this.to.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PokeJSONImpl pokeJSONImpl = (PokeJSONImpl)object;
        if (this.createdTime == null ? pokeJSONImpl.createdTime != null : !this.createdTime.equals(pokeJSONImpl.createdTime)) {
            return false;
        }
        if (this.from == null ? pokeJSONImpl.from != null : !this.from.equals(pokeJSONImpl.from)) {
            return false;
        }
        return !(this.to == null ? pokeJSONImpl.to != null : !this.to.equals(pokeJSONImpl.to));
    }

    public String toString() {
        return "PokeJSONImpl [to=" + this.to + ", from=" + this.from + ", createdTime=" + this.createdTime + "]";
    }
}

