/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.Application;
import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.IdNameEntity;
import be.maximvdw.featherboardcore.facebook.Notification;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.ApplicationJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NotificationJSONImpl
extends FacebookResponseImpl
implements Notification,
Serializable {
    private static final long serialVersionUID = -4598915714655180624L;
    private String id;
    private IdNameEntity from;
    private IdNameEntity to;
    private Date createdTime;
    private Date updatedTime;
    private String title;
    private URL link;
    private Application application;
    private Boolean unread;
    private Notification.TargetObject targetObject;

    NotificationJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    NotificationJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                jSONObject2 = jSONObject.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(jSONObject2);
            }
            if (!jSONObject.isNull("to")) {
                jSONObject2 = jSONObject.getJSONObject("to");
                this.to = new IdNameEntityJSONImpl(jSONObject2);
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
            this.title = z_F4JInternalParseUtil.getRawString("title", jSONObject);
            this.link = z_F4JInternalParseUtil.getURL("link", jSONObject);
            if (!jSONObject.isNull("application")) {
                this.application = new ApplicationJSONImpl(jSONObject.getJSONObject("application"));
            }
            if (!jSONObject.isNull("unread")) {
                this.unread = z_F4JInternalParseUtil.getFlag("unread", jSONObject);
            }
            if (!jSONObject.isNull("object")) {
                this.targetObject = new TargetObjectJSONImpl(jSONObject.getJSONObject("object"));
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public IdNameEntity getTo() {
        return this.to;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public Boolean unread() {
        return this.unread;
    }

    @Override
    public Notification.TargetObject getTargetObject() {
        return this.targetObject;
    }

    static ResponseList<Notification> createNotificationList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Notification> responseListImpl = new ResponseListImpl<Notification>(n2, jSONObject, new Notification[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                NotificationJSONImpl notificationJSONImpl = new NotificationJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(notificationJSONImpl, jSONObject2);
                }
                responseListImpl.add(notificationJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NotificationJSONImpl notificationJSONImpl = (NotificationJSONImpl)object;
        return !(this.id == null ? notificationJSONImpl.id != null : !this.id.equals(notificationJSONImpl.id));
    }

    public String toString() {
        return "NotificationJSONImpl [id=" + this.id + ", from=" + this.from + ", to=" + this.to + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", title=" + this.title + ", link=" + this.link + ", application=" + this.application + ", unread=" + this.unread + "]";
    }

    private static class TargetObjectJSONImpl
    implements Notification.TargetObject,
    Serializable {
        private static final long serialVersionUID = 6760783049866927374L;
        private String id;
        private String type;

        TargetObjectJSONImpl(JSONObject jSONObject) {
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            this.type = z_F4JInternalParseUtil.getRawString("type", jSONObject);
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof TargetObjectJSONImpl)) {
                return false;
            }
            TargetObjectJSONImpl targetObjectJSONImpl = (TargetObjectJSONImpl)object;
            return !(this.id != null ? !this.id.equals(targetObjectJSONImpl.id) : targetObjectJSONImpl.id != null);
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }

        public String toString() {
            return "TargetObjectJSONImpl{id='" + this.id + '\'' + ", type='" + this.type + '\'' + '}';
        }
    }
}

