/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.FriendRequest;
import be.maximvdw.featherboardcore.facebook.IdNameEntity;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FriendRequestJSONImpl
extends FacebookResponseImpl
implements FriendRequest,
Serializable {
    private static final long serialVersionUID = 6531121120616740631L;
    private IdNameEntity from;
    private IdNameEntity to;
    private Date createdTime;
    private String message;
    private Boolean unread;

    FriendRequestJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    FriendRequestJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2;
            if (!jSONObject.isNull("from")) {
                jSONObject2 = jSONObject.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(jSONObject2);
            } else {
                this.from = null;
            }
            if (!jSONObject.isNull("to")) {
                jSONObject2 = jSONObject.getJSONObject("to");
                this.to = new IdNameEntityJSONImpl(jSONObject2);
            } else {
                this.to = null;
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            this.message = z_F4JInternalParseUtil.getRawString("message", jSONObject);
            this.unread = z_F4JInternalParseUtil.getBoolean("unread", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public IdNameEntity getTo() {
        return this.to;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Boolean unread() {
        return this.unread;
    }

    static ResponseList<FriendRequest> createFriendRequestList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<FriendRequest> responseListImpl = new ResponseListImpl<FriendRequest>(n2, jSONObject, new FriendRequest[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                FriendRequestJSONImpl friendRequestJSONImpl = new FriendRequestJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(friendRequestJSONImpl, jSONObject2);
                }
                responseListImpl.add(friendRequestJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.createdTime == null ? 0 : this.createdTime.hashCode());
        n3 = 31 * n3 + (this.from == null ? 0 : this.from.hashCode());
        n3 = 31 * n3 + (this.message == null ? 0 : this.message.hashCode());
        n3 = 31 * n3 + (this.to == null ? 0 : this.to.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FriendRequestJSONImpl friendRequestJSONImpl = (FriendRequestJSONImpl)object;
        if (this.createdTime == null ? friendRequestJSONImpl.createdTime != null : !this.createdTime.equals(friendRequestJSONImpl.createdTime)) {
            return false;
        }
        if (this.from == null ? friendRequestJSONImpl.from != null : !this.from.equals(friendRequestJSONImpl.from)) {
            return false;
        }
        if (this.message == null ? friendRequestJSONImpl.message != null : !this.message.equals(friendRequestJSONImpl.message)) {
            return false;
        }
        return !(this.to == null ? friendRequestJSONImpl.to != null : !this.to.equals(friendRequestJSONImpl.to));
    }

    public String toString() {
        return "FriendRequestJSONImpl [from=" + this.from + ", to=" + this.to + ", createdTime=" + this.createdTime + ", unread=" + this.unread + "]";
    }
}

