/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.Category;
import be.maximvdw.featherboardcore.facebook.Event;
import be.maximvdw.featherboardcore.facebook.EventPrivacyType;
import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.ResponseList;
import be.maximvdw.featherboardcore.facebook.Venue;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.CategoryJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.featherboardcore.facebook.internal.json.VenueJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.featherboardcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EventJSONImpl
extends FacebookResponseImpl
implements Event,
Serializable {
    private static final long serialVersionUID = 6176123276059683967L;
    private String id;
    private Category owner;
    private String name;
    private String description;
    private Boolean isDateOnly;
    private Date startTime;
    private Date endTime;
    private String location;
    private Venue venue;
    private EventPrivacyType privacy;
    private Date updatedTime;
    private String rsvpStatus;
    private URI ticketURI;
    private TimeZone timezone;

    EventJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    EventJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("owner")) {
                jSONObject2 = jSONObject.getJSONObject("owner");
                this.owner = new CategoryJSONImpl(jSONObject2);
            }
            this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
            this.description = z_F4JInternalParseUtil.getRawString("description", jSONObject);
            this.isDateOnly = z_F4JInternalParseUtil.getBoolean("is_date_only", jSONObject);
            this.startTime = z_F4JInternalParseUtil.getISO8601Datetime("start_time", jSONObject);
            this.endTime = z_F4JInternalParseUtil.getISO8601Datetime("end_time", jSONObject);
            this.location = z_F4JInternalParseUtil.getRawString("location", jSONObject);
            if (!jSONObject.isNull("venue")) {
                jSONObject2 = jSONObject.getJSONObject("venue");
                this.venue = new VenueJSONImpl(jSONObject2);
            }
            this.privacy = EventPrivacyType.getInstance(z_F4JInternalParseUtil.getRawString("privacy", jSONObject));
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
            this.rsvpStatus = z_F4JInternalParseUtil.getRawString("rsvp_status", jSONObject);
            this.ticketURI = z_F4JInternalParseUtil.getURI("ticket_uri", jSONObject);
            this.timezone = z_F4JInternalParseUtil.getTimeZone("timezone", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getOwner() {
        return this.owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Boolean isDateOnly() {
        return this.isDateOnly;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public Venue getVenue() {
        return this.venue;
    }

    @Override
    public EventPrivacyType getPrivacy() {
        return this.privacy;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public String getRsvpStatus() {
        return this.rsvpStatus;
    }

    @Override
    public URI getTicketURI() {
        return this.ticketURI;
    }

    @Override
    public TimeZone getTimezone() {
        return this.timezone;
    }

    static ResponseList<Event> createEventList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Event> responseListImpl = new ResponseListImpl<Event>(n2, jSONObject, new Event[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                EventJSONImpl eventJSONImpl = new EventJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(eventJSONImpl, jSONObject2);
                }
                responseListImpl.add(eventJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventJSONImpl eventJSONImpl = (EventJSONImpl)object;
        return !(this.id == null ? eventJSONImpl.id != null : !this.id.equals(eventJSONImpl.id));
    }

    public String toString() {
        return "EventJSONImpl{id='" + this.id + '\'' + ", owner=" + this.owner + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", isDateOnly=" + this.isDateOnly + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", location='" + this.location + '\'' + ", venue=" + this.venue + ", privacy=" + (Object)((Object)this.privacy) + ", updatedTime=" + this.updatedTime + ", rsvpStatus='" + this.rsvpStatus + '\'' + ", ticketURI=" + this.ticketURI + ", timezone=" + this.timezone + '}';
    }
}

