/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.json;

import be.maximvdw.featherboardcore.facebook.Domain;
import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.featherboardcore.facebook.internal.json.IdNameJSONImpl;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DomainJSONImpl
extends IdNameJSONImpl
implements Domain,
Serializable {
    private static final long serialVersionUID = 3035743532170128485L;

    DomainJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse, configuration);
    }

    DomainJSONImpl(JSONObject jSONObject) {
        super(jSONObject);
    }

    static List<Domain> createDomainArray(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            ArrayList<Domain> arrayList = new ArrayList<Domain>();
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                JSONObject jSONObject2 = (JSONObject)jSONObject.get(string);
                DomainJSONImpl domainJSONImpl = new DomainJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(domainJSONImpl, jSONObject2);
                }
                arrayList.add(domainJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(arrayList, jSONObject);
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    @Override
    public String toString() {
        return "DomainJSONImpl [id=" + this.id + ", name=" + this.name + "]";
    }
}

