/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook.internal.http;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.auth.Authorization;
import be.maximvdw.featherboardcore.facebook.conf.ConfigurationContext;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpClient;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpClientFactory;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpClientWrapperConfiguration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpParameter;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpRequest;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponseEvent;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponseListener;
import be.maximvdw.featherboardcore.facebook.internal.http.RequestMethod;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientWrapper
implements Serializable {
    private final HttpClientWrapperConfiguration wrapperConf;
    private HttpClient http;
    private final Map<String, String> requestHeaders;
    private static final long serialVersionUID = -6511977105603119379L;
    private HttpResponseListener httpResponseListener;

    public HttpClientWrapper(HttpClientWrapperConfiguration httpClientWrapperConfiguration) {
        this.wrapperConf = httpClientWrapperConfiguration;
        this.requestHeaders = httpClientWrapperConfiguration.getRequestHeaders();
        this.http = HttpClientFactory.getInstance(httpClientWrapperConfiguration);
    }

    public HttpClientWrapper() {
        this.wrapperConf = ConfigurationContext.getInstance();
        this.requestHeaders = this.wrapperConf.getRequestHeaders();
        this.http = HttpClientFactory.getInstance(this.wrapperConf);
    }

    public void shutdown() {
        this.http.shutdown();
    }

    protected HttpResponse request(HttpRequest httpRequest) {
        HttpResponse httpResponse;
        try {
            httpResponse = this.http.request(httpRequest);
            if (this.httpResponseListener != null) {
                this.httpResponseListener.httpResponseReceived(new HttpResponseEvent(httpRequest, httpResponse, null));
            }
        }
        catch (FacebookException facebookException) {
            if (this.httpResponseListener != null) {
                this.httpResponseListener.httpResponseReceived(new HttpResponseEvent(httpRequest, null, facebookException));
            }
            throw facebookException;
        }
        return httpResponse;
    }

    public void setHttpResponseListener(HttpResponseListener httpResponseListener) {
        this.httpResponseListener = httpResponseListener;
    }

    public HttpResponse get(String string, HttpParameter[] httpParameterArray, Authorization authorization) {
        return this.request(new HttpRequest(RequestMethod.GET, string, httpParameterArray, authorization, this.requestHeaders));
    }

    public HttpResponse get(String string, HttpParameter[] httpParameterArray) {
        return this.request(new HttpRequest(RequestMethod.GET, string, httpParameterArray, null, this.requestHeaders));
    }

    public HttpResponse get(String string, Authorization authorization) {
        return this.request(new HttpRequest(RequestMethod.GET, string, null, authorization, this.requestHeaders));
    }

    public HttpResponse get(String string) {
        return this.request(new HttpRequest(RequestMethod.GET, string, null, null, this.requestHeaders));
    }

    public HttpResponse post(String string, HttpParameter[] httpParameterArray, Authorization authorization) {
        return this.request(new HttpRequest(RequestMethod.POST, string, httpParameterArray, authorization, this.requestHeaders));
    }

    public HttpResponse post(String string, HttpParameter[] httpParameterArray) {
        return this.request(new HttpRequest(RequestMethod.POST, string, httpParameterArray, null, this.requestHeaders));
    }

    public HttpResponse post(String string, HttpParameter[] httpParameterArray, Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.requestHeaders);
        if (map != null) {
            hashMap.putAll(map);
        }
        return this.request(new HttpRequest(RequestMethod.POST, string, httpParameterArray, null, hashMap));
    }

    public HttpResponse post(String string, Authorization authorization) {
        return this.request(new HttpRequest(RequestMethod.POST, string, null, authorization, this.requestHeaders));
    }

    public HttpResponse post(String string) {
        return this.request(new HttpRequest(RequestMethod.POST, string, null, null, this.requestHeaders));
    }

    public HttpResponse delete(String string, HttpParameter[] httpParameterArray, Authorization authorization) {
        return this.request(new HttpRequest(RequestMethod.DELETE, string, httpParameterArray, authorization, this.requestHeaders));
    }

    public HttpResponse delete(String string, HttpParameter[] httpParameterArray) {
        return this.request(new HttpRequest(RequestMethod.DELETE, string, httpParameterArray, null, this.requestHeaders));
    }

    public HttpResponse delete(String string, Authorization authorization) {
        return this.request(new HttpRequest(RequestMethod.DELETE, string, null, authorization, this.requestHeaders));
    }

    public HttpResponse delete(String string) {
        return this.request(new HttpRequest(RequestMethod.DELETE, string, null, null, this.requestHeaders));
    }

    public HttpResponse head(String string, HttpParameter[] httpParameterArray, Authorization authorization) {
        return this.request(new HttpRequest(RequestMethod.HEAD, string, httpParameterArray, authorization, this.requestHeaders));
    }

    public HttpResponse head(String string, HttpParameter[] httpParameterArray) {
        return this.request(new HttpRequest(RequestMethod.HEAD, string, httpParameterArray, null, this.requestHeaders));
    }

    public HttpResponse head(String string, Authorization authorization) {
        return this.request(new HttpRequest(RequestMethod.HEAD, string, null, authorization, this.requestHeaders));
    }

    public HttpResponse head(String string) {
        return this.request(new HttpRequest(RequestMethod.HEAD, string, null, null, this.requestHeaders));
    }

    public HttpResponse put(String string, HttpParameter[] httpParameterArray, Authorization authorization) {
        return this.request(new HttpRequest(RequestMethod.PUT, string, httpParameterArray, authorization, this.requestHeaders));
    }

    public HttpResponse put(String string, HttpParameter[] httpParameterArray) {
        return this.request(new HttpRequest(RequestMethod.PUT, string, httpParameterArray, null, this.requestHeaders));
    }

    public HttpResponse put(String string, Authorization authorization) {
        return this.request(new HttpRequest(RequestMethod.PUT, string, null, authorization, this.requestHeaders));
    }

    public HttpResponse put(String string) {
        return this.request(new HttpRequest(RequestMethod.PUT, string, null, null, this.requestHeaders));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HttpClientWrapper httpClientWrapper = (HttpClientWrapper)object;
        if (!this.http.equals(httpClientWrapper.http)) {
            return false;
        }
        if (!((Object)this.requestHeaders).equals(httpClientWrapper.requestHeaders)) {
            return false;
        }
        return this.wrapperConf.equals(httpClientWrapper.wrapperConf);
    }

    public int hashCode() {
        int n2 = this.wrapperConf.hashCode();
        n2 = 31 * n2 + this.http.hashCode();
        n2 = 31 * n2 + ((Object)this.requestHeaders).hashCode();
        return n2;
    }

    public String toString() {
        return "HttpClientWrapper{wrapperConf=" + this.wrapperConf + ", http=" + this.http + ", requestHeaders=" + this.requestHeaders + ", httpResponseListener=" + this.httpResponseListener + '}';
    }
}

