/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook;

import be.maximvdw.featherboardcore.facebook.Version;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpResponse;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import java.io.IOException;
import java.util.List;

public class FacebookException
extends Exception {
    private static final long serialVersionUID = 1200504652249544235L;
    private int statusCode = -1;
    private HttpResponse response;
    private String errorType;
    private String errorMessage;
    private int errorCode = -1;
    private int errorSubcode = -1;

    public FacebookException(String string, Throwable throwable) {
        super(string, throwable);
        this.decode(string);
    }

    public FacebookException(String string, HttpResponse httpResponse) {
        this(string);
        this.response = httpResponse;
        this.statusCode = httpResponse.getStatusCode();
    }

    public FacebookException(String string) {
        this(string, (Throwable)null);
    }

    public FacebookException(Throwable throwable) {
        this(throwable.getMessage(), throwable);
    }

    public FacebookException(String string, Throwable throwable, int n2) {
        this(string, throwable);
        this.statusCode = n2;
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.errorMessage != null && this.errorCode != -1) {
            stringBuilder.append("message - ").append(this.errorMessage).append("\n");
            stringBuilder.append("code - ").append(this.errorCode).append("\n");
            if (this.errorSubcode != -1) {
                stringBuilder.append("subcode - ").append(this.errorSubcode).append("\n");
            }
            stringBuilder.append("Relevant information for error recovery can be found on the Facebook Developers Document:\n").append("\thttps://developers.facebook.com/docs/graph-api/using-graph-api/#errors\n");
        } else {
            stringBuilder.append(super.getMessage());
        }
        return stringBuilder.toString();
    }

    private void decode(String string) {
        if (string != null && string.startsWith("{")) {
            try {
                JSONObject jSONObject = new JSONObject(string);
                if (!jSONObject.isNull("error")) {
                    JSONObject jSONObject2 = jSONObject.getJSONObject("error");
                    this.errorType = jSONObject2.getString("type");
                    this.errorMessage = jSONObject2.getString("message");
                    this.errorCode = jSONObject2.getInt("code");
                    this.errorSubcode = jSONObject2.getInt("error_subcode");
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getErrorSubcode() {
        return this.errorSubcode;
    }

    public String getResponseHeader(String string) {
        List<String> list;
        String string2 = null;
        if (this.response != null && (list = this.response.getResponseHeaderFields().get(string)).size() > 0) {
            string2 = list.get(0);
        }
        return string2;
    }

    public boolean isCausedByNetworkIssue() {
        return this.getCause() instanceof IOException;
    }

    public boolean resourceNotFound() {
        return this.statusCode == 404;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FacebookException)) {
            return false;
        }
        FacebookException facebookException = (FacebookException)object;
        if (this.errorCode != facebookException.errorCode) {
            return false;
        }
        if (this.errorSubcode != facebookException.errorSubcode) {
            return false;
        }
        if (this.statusCode != facebookException.statusCode) {
            return false;
        }
        if (this.errorMessage != null ? !this.errorMessage.equals(facebookException.errorMessage) : facebookException.errorMessage != null) {
            return false;
        }
        if (this.errorType != null ? !this.errorType.equals(facebookException.errorType) : facebookException.errorType != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals(facebookException.response) : facebookException.response != null);
    }

    public int hashCode() {
        int n2 = this.statusCode;
        n2 = 31 * n2 + (this.response != null ? this.response.hashCode() : 0);
        n2 = 31 * n2 + (this.errorType != null ? this.errorType.hashCode() : 0);
        n2 = 31 * n2 + (this.errorMessage != null ? this.errorMessage.hashCode() : 0);
        n2 = 31 * n2 + this.errorCode;
        n2 = 31 * n2 + this.errorSubcode;
        return n2;
    }

    public String toString() {
        return this.getMessage() + "\nFacebookException{" + "statusCode=" + this.statusCode + ", errorType='" + this.errorType + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", errorCode=" + this.errorCode + ", errorSubcode=" + this.errorSubcode + ", version=" + Version.getVersion() + '}';
    }
}

