/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.facebook;

import be.maximvdw.featherboardcore.facebook.FacebookException;
import be.maximvdw.featherboardcore.facebook.auth.AccessToken;
import be.maximvdw.featherboardcore.facebook.auth.AuthOption;
import be.maximvdw.featherboardcore.facebook.auth.Authorization;
import be.maximvdw.featherboardcore.facebook.auth.DeviceCode;
import be.maximvdw.featherboardcore.facebook.auth.NullAuthOption;
import be.maximvdw.featherboardcore.facebook.auth.NullAuthorization;
import be.maximvdw.featherboardcore.facebook.auth.OAuthAuthorization;
import be.maximvdw.featherboardcore.facebook.auth.OAuthSupport;
import be.maximvdw.featherboardcore.facebook.conf.Configuration;
import be.maximvdw.featherboardcore.facebook.internal.http.HttpClientWrapper;
import be.maximvdw.featherboardcore.facebook.internal.json.z_F4JInternalFactory;
import be.maximvdw.featherboardcore.facebook.internal.json.z_F4JInternalJSONImplFactory;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONException;
import be.maximvdw.featherboardcore.facebook.internal.org.json.JSONObject;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

abstract class FacebookBaseImpl
implements OAuthSupport,
Serializable {
    private static final long serialVersionUID = 5812835429308976884L;
    protected transient HttpClientWrapper http;
    protected z_F4JInternalFactory factory;
    protected Configuration conf;
    protected Authorization auth;
    protected transient String id;
    protected transient String name;

    FacebookBaseImpl(Configuration configuration, Authorization authorization) {
        this.conf = configuration;
        this.auth = authorization;
        this.init();
    }

    private void init() {
        if (null == this.auth) {
            String string = this.conf.getOAuthAppId();
            String string2 = this.conf.getOAuthAppSecret();
            if (string != null && string2 != null) {
                OAuthAuthorization oAuthAuthorization = new OAuthAuthorization(this.conf);
                String string3 = this.conf.getOAuthAccessToken();
                String string4 = this.conf.getOAuthCallbackURL();
                if (string3 != null) {
                    if (string4 != null) {
                        oAuthAuthorization.setOAuthAccessToken(new AccessToken(string3, null), string4);
                    } else {
                        oAuthAuthorization.setOAuthAccessToken(new AccessToken(string3, null));
                    }
                }
                this.auth = oAuthAuthorization;
            } else {
                this.auth = NullAuthorization.getInstance();
            }
        }
        this.setHttp();
        this.setFactory();
    }

    protected void setHttp() {
        this.http = new HttpClientWrapper(this.conf);
    }

    protected void setFactory() {
        this.factory = new z_F4JInternalJSONImplFactory(this.conf);
    }

    public String getId() {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth app ID/secret combination supplied");
        }
        if (this.id == null) {
            this.fillInIDAndName();
        }
        return this.id;
    }

    public String getName() {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth app ID/secret combination supplied");
        }
        if (this.name == null) {
            this.fillInIDAndName();
        }
        return this.name;
    }

    protected void fillInIDAndName() {
        this.ensureAuthorizationEnabled();
        JSONObject jSONObject = this.http.get(this.conf.getRestBaseURL() + "me?fields=id,name", this.auth).asJSONObject();
        try {
            this.id = jSONObject.getString("id");
            this.name = jSONObject.getString("name");
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public final Authorization getAuthorization() {
        return this.auth;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public void shutdown() {
        if (this.http != null) {
            this.http.shutdown();
        }
    }

    protected final void ensureAuthorizationEnabled() {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Authentication credentials are missing.");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.putFields();
        objectOutputStream.writeFields();
        objectOutputStream.writeObject(this.conf);
        objectOutputStream.writeObject(this.auth);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.readFields();
        this.conf = (Configuration)objectInputStream.readObject();
        this.auth = (Authorization)objectInputStream.readObject();
        this.http = new HttpClientWrapper(this.conf);
        this.setFactory();
    }

    public void setOAuthAppId(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("app id is null");
        }
        if (string2 == null) {
            throw new NullPointerException("app secret is null");
        }
        if (this.auth instanceof NullAuthorization) {
            OAuthAuthorization oAuthAuthorization = new OAuthAuthorization(this.conf);
            oAuthAuthorization.setOAuthAppId(string, string2);
            this.auth = oAuthAuthorization;
        } else if (this.auth instanceof OAuthAuthorization) {
            throw new IllegalStateException("app id/secret pair already set.");
        }
    }

    public void setOAuthPermissions(String string) {
        this.getOAuth().setOAuthPermissions(string);
    }

    public String getOAuthAuthorizationURL(String string) {
        return this.getOAuthAuthorizationURL(string, new NullAuthOption());
    }

    public String getOAuthAuthorizationURL(String string, String string2) {
        return this.getOAuth().getOAuthAuthorizationURL(string, string2);
    }

    public String getOAuthAuthorizationURL(String string, AuthOption authOption) {
        return this.getOAuth().getOAuthAuthorizationURL(string, authOption);
    }

    public String getOAuthReAuthenticationURL(String string, String string2) {
        return this.getOAuth().getOAuthReAuthenticationURL(string, string2);
    }

    public AccessToken getOAuthAccessToken() {
        return this.getOAuth().getOAuthAccessToken();
    }

    public synchronized AccessToken getOAuthAccessToken(String string) {
        return this.getOAuth().getOAuthAccessToken(string);
    }

    public synchronized AccessToken getOAuthAccessToken(String string, String string2) {
        return this.getOAuth().getOAuthAccessToken(string, string2);
    }

    public AccessToken getOAuthAppAccessToken() {
        return this.getOAuth().getOAuthAppAccessToken();
    }

    public synchronized DeviceCode getOAuthDeviceCode() {
        return this.getOAuth().getOAuthDeviceCode();
    }

    public synchronized AccessToken getOAuthDeviceToken(DeviceCode deviceCode) {
        return this.getOAuth().getOAuthDeviceToken(deviceCode);
    }

    public void setOAuthAccessToken(AccessToken accessToken) {
        this.getOAuth().setOAuthAccessToken(accessToken);
    }

    public String getOAuthCallbackURL() {
        return this.getOAuth().getOAuthCallbackURL();
    }

    public void setOAuthCallbackURL(String string) {
        this.getOAuth().setOAuthCallbackURL(string);
    }

    public AccessToken extendTokenExpiration(String string) {
        return this.getOAuth().extendTokenExpiration(string);
    }

    public AccessToken extendTokenExpiration() {
        return this.extendTokenExpiration(this.getOAuthAccessToken().getToken());
    }

    public AccessToken getOAuthAccessTokenInfo(String string) {
        return this.getOAuth().getOAuthAccessTokenInfo(string);
    }

    public AccessToken getOAuthAccessTokenInfo() {
        return this.getOAuth().getOAuthAccessTokenInfo();
    }

    private OAuthSupport getOAuth() {
        if (!(this.auth instanceof OAuthSupport)) {
            throw new IllegalStateException("OAuth app id/secret combination not supplied");
        }
        return (OAuthSupport)((Object)this.auth);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FacebookBaseImpl facebookBaseImpl = (FacebookBaseImpl)object;
        if (this.auth == null ? facebookBaseImpl.auth != null : !this.auth.equals(facebookBaseImpl.auth)) {
            return false;
        }
        if (this.conf == null ? facebookBaseImpl.conf != null : !this.conf.equals(facebookBaseImpl.conf)) {
            return false;
        }
        return !(this.http == null ? facebookBaseImpl.http != null : !this.http.equals(facebookBaseImpl.http));
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.auth == null ? 0 : this.auth.hashCode());
        n3 = 31 * n3 + (this.conf == null ? 0 : this.conf.hashCode());
        n3 = 31 * n3 + (this.http == null ? 0 : this.http.hashCode());
        return n3;
    }

    public String toString() {
        return "FacebookBaseImpl [http=" + this.http + ", conf=" + this.conf + ", auth=" + this.auth + "]";
    }
}

