/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.eventhooks;

import be.maximvdw.featherboardcore.eventhooks.BaseEventHook;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class VanillaReJoinHook
extends BaseEventHook {
    private Map<Player, Long> players = new HashMap<Player, Long>();
    int repeatingTask = -1;
    private long onscreenTime = 10L;

    public VanillaReJoinHook(Plugin plugin) {
        super(plugin, "vanilla-rejoin", 1);
        this.setName("Vanilla player rejoin");
        this.setDescription("Player rejoining");
        this.setWhen("the player rejoins the server");
        this.setWho("the player that rejoined");
        this.generateConfig();
        this.getConfigTemplate().b(" The time to display the " + VanillaReJoinHook.getActionName() + " on the screen (in millseconds)");
        this.getConfigTemplate().a("onscreen-time", 5000);
        VanillaReJoinHook.registerHook(this);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (!this.players.containsKey(player)) {
            this.enableEvent(player);
        }
        this.players.put(player, System.currentTimeMillis());
    }

    @Override
    public void start() {
        this.onscreenTime = this.getConfig().getLong("onscreen-time");
        if (this.repeatingTask == -1) {
            this.getPlugin().getServer().getScheduler().runTaskTimerAsynchronously(this.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    try {
                        HashMap hashMap = new HashMap(VanillaReJoinHook.this.players);
                        Long l2 = System.currentTimeMillis();
                        for (Player player : hashMap.keySet()) {
                            if (player == null) {
                                VanillaReJoinHook.this.players.remove(player);
                                continue;
                            }
                            if (!player.isOnline()) {
                                VanillaReJoinHook.this.players.remove(player);
                                continue;
                            }
                            Long l3 = (Long)hashMap.get(player);
                            if (l2 - l3 <= VanillaReJoinHook.this.onscreenTime) continue;
                            VanillaReJoinHook.this.disableEvent(player);
                            VanillaReJoinHook.this.players.remove(player);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }, 1L, 1L);
        }
    }
}

