/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.eventhooks;

import be.maximvdw.featherboardcore.eventhooks.BaseEventHook;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;

public class VanillaDeathHook
extends BaseEventHook {
    private Map<Player, Long> players = new HashMap<Player, Long>();
    int repeatingTask = -1;
    private long onscreenTime = 10L;

    public VanillaDeathHook(Plugin plugin) {
        super(plugin, "vanilla-death", 1);
        this.setName("Vanilla Death hook");
        this.setDescription("Player Death hook in minecraft");
        this.setWhen("the player dies");
        this.setWho("the player that dies");
        this.generateConfig();
        this.getConfigTemplate().b(" The time to display the " + VanillaDeathHook.getActionName() + " on the screen (in millseconds)");
        this.getConfigTemplate().a("onscreen-time", 5000);
        VanillaDeathHook.registerHook(this);
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        if (!this.players.containsKey(player)) {
            this.enableEvent(player);
        }
        this.players.put(player, System.currentTimeMillis());
    }

    @Override
    public void start() {
        this.onscreenTime = this.getConfig().getLong("onscreen-time");
        if (this.repeatingTask == -1) {
            this.getPlugin().getServer().getScheduler().runTaskTimerAsynchronously(this.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    try {
                        HashMap hashMap = new HashMap(VanillaDeathHook.this.players);
                        Long l2 = System.currentTimeMillis();
                        for (Player player : hashMap.keySet()) {
                            if (player == null) {
                                VanillaDeathHook.this.players.remove(player);
                                continue;
                            }
                            if (!player.isOnline()) {
                                VanillaDeathHook.this.players.remove(player);
                                continue;
                            }
                            Long l3 = (Long)hashMap.get(player);
                            if (l2 - l3 <= VanillaDeathHook.this.onscreenTime) continue;
                            VanillaDeathHook.this.disableEvent(player);
                            VanillaDeathHook.this.players.remove(player);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }, 1L, 1L);
        }
    }
}

