/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.eventhooks;

import be.maximvdw.featherboardcore.eventhooks.BaseEventHook;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityCreatePortalEvent;
import org.bukkit.plugin.Plugin;

public class VanillaCreatePortalHook
extends BaseEventHook {
    private Map<Player, Long> players = new HashMap<Player, Long>();
    int repeatingTask = -1;
    private long onscreenTime = 10L;

    public VanillaCreatePortalHook(Plugin plugin) {
        super(plugin, "vanilla-createportal", 1);
        this.setName("Vanilla Create portal hook");
        this.setDescription("Player Create portal hook in minecraft");
        this.setWhen("the player creates a portal");
        this.setWho("the player that created a portal");
        this.generateConfig();
        this.getConfigTemplate().b(" The time to display the " + VanillaCreatePortalHook.getActionName() + " on the screen (in millseconds)");
        this.getConfigTemplate().a("onscreen-time", 5000);
        VanillaCreatePortalHook.registerHook(this);
    }

    @EventHandler
    public void onCreate(EntityCreatePortalEvent entityCreatePortalEvent) {
        if (entityCreatePortalEvent.isCancelled()) {
            return;
        }
        if (!entityCreatePortalEvent.getEntityType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        Player player = (Player)entityCreatePortalEvent.getEntity();
        if (!this.players.containsKey(player)) {
            this.enableEvent(player);
        }
        this.players.put(player, System.currentTimeMillis());
    }

    @Override
    public void start() {
        this.onscreenTime = this.getConfig().getLong("onscreen-time");
        if (this.repeatingTask == -1) {
            this.getPlugin().getServer().getScheduler().runTaskTimerAsynchronously(this.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    try {
                        HashMap hashMap = new HashMap(VanillaCreatePortalHook.this.players);
                        Long l2 = System.currentTimeMillis();
                        for (Player player : hashMap.keySet()) {
                            if (player == null) {
                                VanillaCreatePortalHook.this.players.remove(player);
                                continue;
                            }
                            if (!player.isOnline()) {
                                VanillaCreatePortalHook.this.players.remove(player);
                                continue;
                            }
                            Long l3 = (Long)hashMap.get(player);
                            if (l2 - l3 <= VanillaCreatePortalHook.this.onscreenTime) continue;
                            VanillaCreatePortalHook.this.disableEvent(player);
                            VanillaCreatePortalHook.this.players.remove(player);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }, 1L, 1L);
        }
    }
}

