/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.eventhooks;

import be.maximvdw.featherboardcore.eventhooks.BaseEventHook;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;

public class VanillaBlockPlaceHook
extends BaseEventHook {
    private Map<Player, Long> players = new HashMap<Player, Long>();
    int repeatingTask = -1;
    private long onscreenTime = 10L;

    public VanillaBlockPlaceHook(Plugin plugin) {
        super(plugin, "vanilla-blockplace", 1);
        this.setName("Vanilla Block place hook");
        this.setDescription("Player block place in minecraft");
        this.setWhen("the player places a block");
        this.setWho("the player that placed a block");
        this.generateConfig();
        this.getConfigTemplate().b(" The time to display the board on the screen (in millseconds)");
        this.getConfigTemplate().a("onscreen-time", 5000);
        VanillaBlockPlaceHook.registerHook(this);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        if (blockPlaceEvent.isCancelled()) {
            return;
        }
        Player player = blockPlaceEvent.getPlayer();
        if (!this.players.containsKey(player)) {
            this.enableEvent(player);
        }
        this.players.put(player, System.currentTimeMillis());
    }

    @Override
    public void start() {
        this.onscreenTime = this.getConfig().getLong("onscreen-time");
        if (this.repeatingTask == -1) {
            this.getPlugin().getServer().getScheduler().runTaskTimerAsynchronously(this.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    try {
                        HashMap hashMap = new HashMap(VanillaBlockPlaceHook.this.players);
                        Long l2 = System.currentTimeMillis();
                        for (Player player : hashMap.keySet()) {
                            if (player == null) {
                                VanillaBlockPlaceHook.this.players.remove(player);
                                continue;
                            }
                            if (!player.isOnline()) {
                                VanillaBlockPlaceHook.this.players.remove(player);
                                continue;
                            }
                            Long l3 = (Long)hashMap.get(player);
                            if (l2 - l3 <= VanillaBlockPlaceHook.this.onscreenTime) continue;
                            VanillaBlockPlaceHook.this.disableEvent(player);
                            VanillaBlockPlaceHook.this.players.remove(player);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }, 1L, 1L);
        }
    }
}

