/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.eventhooks;

import be.maximvdw.featherboardcore.eventhooks.BaseEventHook;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class VanillaBlockBreakHook
extends BaseEventHook {
    private Map<Player, Long> players = new HashMap<Player, Long>();
    int repeatingTask = -1;
    private long onscreenTime = 10L;

    public VanillaBlockBreakHook(Plugin plugin) {
        super(plugin, "vanilla-blockbreak", 1);
        this.setName("Vanilla Block break hook");
        this.setDescription("Player block breaking minecraft");
        this.setWhen("the player breaks a block");
        this.setWho("the player that broke a block");
        this.generateConfig();
        this.getConfigTemplate().b(" The time to display the " + VanillaBlockBreakHook.getActionName() + " on the screen (in millseconds)");
        this.getConfigTemplate().a("onscreen-time", 5000);
        VanillaBlockBreakHook.registerHook(this);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        Player player = blockBreakEvent.getPlayer();
        if (!this.players.containsKey(player)) {
            this.enableEvent(player);
        }
        this.players.put(player, System.currentTimeMillis());
    }

    @Override
    public void start() {
        this.onscreenTime = this.getConfig().getLong("onscreen-time");
        if (this.repeatingTask == -1) {
            this.getPlugin().getServer().getScheduler().runTaskTimerAsynchronously(this.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    try {
                        HashMap hashMap = new HashMap(VanillaBlockBreakHook.this.players);
                        Long l2 = System.currentTimeMillis();
                        for (Player player : hashMap.keySet()) {
                            if (player == null) {
                                VanillaBlockBreakHook.this.players.remove(player);
                                continue;
                            }
                            if (!player.isOnline()) {
                                VanillaBlockBreakHook.this.players.remove(player);
                                continue;
                            }
                            Long l3 = (Long)hashMap.get(player);
                            if (l2 - l3 <= VanillaBlockBreakHook.this.onscreenTime) continue;
                            VanillaBlockBreakHook.this.disableEvent(player);
                            VanillaBlockBreakHook.this.players.remove(player);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }, 1L, 1L);
        }
    }
}

