/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.eventhooks;

import be.maximvdw.featherboardcore.eventhooks.BaseEventHook;
import com.garbagemule.MobArena.events.ArenaEndEvent;
import com.garbagemule.MobArena.events.ArenaPlayerDeathEvent;
import com.garbagemule.MobArena.events.ArenaPlayerLeaveEvent;
import com.garbagemule.MobArena.events.ArenaStartEvent;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.plugin.Plugin;

public class MobArenaHook
extends BaseEventHook {
    public MobArenaHook(Plugin plugin) {
        super(plugin, "mobarena", 1);
        this.setName("MobArena");
        this.addCondition(BaseEventHook.a.a, "MobArena");
        this.setDescription("MobArena minigame plugin");
        this.setUrl("http://dev.bukkit.org/bukkit-plugins/mobarena/");
        this.setWhen("the arena starts or stops");
        this.setWho("all players that are in the arena or spectating");
        MobArenaHook.registerHook(this);
    }

    @EventHandler
    public void onArenaStart(ArenaStartEvent arenaStartEvent) {
        if (arenaStartEvent.getArena() == null) {
            return;
        }
        if (arenaStartEvent.getArena().getAllPlayers() == null) {
            return;
        }
        if (arenaStartEvent.getArena().getAllPlayers().size() == 0) {
            return;
        }
        ArrayList arrayList = new ArrayList(arenaStartEvent.getArena().getAllPlayers());
        for (Player player : arrayList) {
            this.enableEvent(player);
        }
    }

    @EventHandler
    public void onArenaLeave(ArenaPlayerLeaveEvent arenaPlayerLeaveEvent) {
        this.disableEvent(arenaPlayerLeaveEvent.getPlayer());
    }

    @EventHandler
    public void onPlayerDeath(ArenaPlayerDeathEvent arenaPlayerDeathEvent) {
        this.disableEvent(arenaPlayerDeathEvent.getPlayer());
    }

    @EventHandler
    public void onArenaStop(ArenaEndEvent arenaEndEvent) {
        if (arenaEndEvent.getArena() == null) {
            return;
        }
        if (arenaEndEvent.getArena().getAllPlayers() == null) {
            return;
        }
        if (arenaEndEvent.getArena().getAllPlayers().size() == 0) {
            return;
        }
        ArrayList arrayList = new ArrayList(arenaEndEvent.getArena().getAllPlayers());
        for (Player player : arrayList) {
            this.disableEvent(player);
        }
    }

    @Override
    public void start() {
    }
}

