/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.eventhooks;

import be.maximvdw.featherboardcore.eventhooks.BaseEventHook;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.events.party.McMMOPartyLevelUpEvent;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.plugin.Plugin;

public class McMMOPartyLevelUpHook
extends BaseEventHook {
    private Map<Player, Long> players = new HashMap<Player, Long>();
    int repeatingTask = -1;
    private long onscreenTime = 10L;

    public McMMOPartyLevelUpHook(Plugin plugin) {
        super(plugin, "mcmmo-partylevelup", 1);
        this.setName("mcMMO Party Level up");
        this.addCondition(BaseEventHook.a.a, "mcMMO");
        this.setDescription("McMMO Skills plugin party player level up");
        this.setUrl("https://www.spigotmc.org/resources/mcmmo.2445/");
        this.setWhen("the party levels up");
        this.setWho("all the players in the party that levels up");
        this.generateConfig();
        this.getConfigTemplate().b(" The time to display the " + McMMOPartyLevelUpHook.getActionName() + " on the screen (in millseconds)");
        this.getConfigTemplate().a("onscreen-time", 5000);
        McMMOPartyLevelUpHook.registerHook(this);
    }

    @EventHandler
    public void onLevelUp(McMMOPartyLevelUpEvent mcMMOPartyLevelUpEvent) {
        if (mcMMOPartyLevelUpEvent.isCancelled()) {
            return;
        }
        Party party = mcMMOPartyLevelUpEvent.getParty();
        if (party == null) {
            return;
        }
        for (Player player : party.getOnlineMembers()) {
            if (!this.players.containsKey(player)) {
                this.enableEvent(player);
            }
            this.players.put(player, System.currentTimeMillis());
        }
    }

    @Override
    public void start() {
        this.onscreenTime = this.getConfig().getLong("onscreen-time");
        if (this.repeatingTask == -1) {
            this.getPlugin().getServer().getScheduler().runTaskTimerAsynchronously(this.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    try {
                        HashMap hashMap = new HashMap(McMMOPartyLevelUpHook.this.players);
                        Long l2 = System.currentTimeMillis();
                        for (Player player : hashMap.keySet()) {
                            if (player == null) {
                                McMMOPartyLevelUpHook.this.players.remove(player);
                                continue;
                            }
                            if (!player.isOnline()) {
                                McMMOPartyLevelUpHook.this.players.remove(player);
                                continue;
                            }
                            Long l3 = (Long)hashMap.get(player);
                            if (l2 - l3 <= McMMOPartyLevelUpHook.this.onscreenTime) continue;
                            McMMOPartyLevelUpHook.this.disableEvent(player);
                            McMMOPartyLevelUpHook.this.players.remove(player);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }, 1L, 1L);
        }
    }
}

