/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.eventhooks;

import be.maximvdw.featherboardcore.eventhooks.BaseEventHook;
import io.github.yannici.bedwars.Events.BedwarsGameEndEvent;
import io.github.yannici.bedwars.Events.BedwarsGameStartEvent;
import io.github.yannici.bedwars.Game.Game;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.plugin.Plugin;

public class BedwardsReloadedHook
extends BaseEventHook {
    public BedwardsReloadedHook(Plugin plugin) {
        super(plugin, "bedwarsreloaded", 1);
        this.setName("BedwarsRel");
        this.addCondition(BaseEventHook.a.a, "BedwarsRel");
        this.setDescription("BedwarsReloaded minigame plugin");
        this.setUrl("https://www.spigotmc.org/resources/bedwars-rel.6799/");
        this.setWhen("the Bedwars game starts or stops");
        this.setWho("all players in the game");
        BedwardsReloadedHook.registerHook(this);
    }

    @EventHandler
    public void onArenaStart(BedwarsGameStartEvent bedwarsGameStartEvent) {
        if (bedwarsGameStartEvent.isCancelled()) {
            return;
        }
        Game game = bedwarsGameStartEvent.getGame();
        if (game == null) {
            return;
        }
        for (Player player : game.getPlayers()) {
            this.enableEvent(player);
        }
    }

    @EventHandler
    public void onArenaStop(BedwarsGameEndEvent bedwarsGameEndEvent) {
        Game game = bedwarsGameEndEvent.getGame();
        if (game == null) {
            return;
        }
        for (Player player : game.getPlayers()) {
            this.disableEvent(player);
        }
    }

    @Override
    public void start() {
    }
}

