/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.UserMap;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.craftbukkit.BanLookup;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class Commandseen
extends EssentialsCommand {
    public Commandseen() {
        super("seen");
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        this.seen(server, sender, commandLabel, args, true, true, true);
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        this.seen(server, user.getSource(), commandLabel, args, user.isAuthorized("essentials.seen.banreason"), user.isAuthorized("essentials.seen.extra"), user.isAuthorized("essentials.seen.ipsearch"));
    }

    protected void seen(final Server server, final CommandSource sender, final String commandLabel, final String[] args, final boolean showBan, final boolean extra, boolean ipLookup) throws Exception {
        User player;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        try {
            UUID uuid = UUID.fromString(args[0]);
            player = this.ess.getUser(uuid);
        }
        catch (IllegalArgumentException ignored) {
            player = this.ess.getOfflineUser(args[0]);
        }
        if (player == null) {
            if (ipLookup && FormatUtil.validIP(args[0])) {
                this.seenIP(server, sender, args[0]);
                return;
            }
            if (this.ess.getServer().getBanList(BanList.Type.IP).isBanned(args[0])) {
                sender.sendMessage(I18n.tl("isIpBanned", args[0]));
                return;
            }
            if (BanLookup.isBanned(this.ess, args[0]).booleanValue()) {
                sender.sendMessage(I18n.tl("whoisBanned", showBan ? BanLookup.getBanEntry(this.ess, args[0]).getReason() : I18n.tl("true", new Object[0])));
                return;
            }
            this.ess.getScheduler().runTaskAsynchronously((Plugin)this.ess, new Runnable(){

                @Override
                public void run() {
                    User userFromBukkit = Commandseen.this.ess.getUserMap().getUserFromBukkit(args[0]);
                    try {
                        if (userFromBukkit != null) {
                            this.showUserSeen(userFromBukkit);
                        } else {
                            this.showUserSeen(Commandseen.this.getPlayer(server, sender, args, 0));
                        }
                    }
                    catch (Exception e) {
                        Commandseen.this.ess.showError(sender, e, commandLabel);
                    }
                }

                private void showUserSeen(User user) throws Exception {
                    if (user == null) {
                        throw new PlayerNotFoundException();
                    }
                    Commandseen.this.showSeenMessage(server, sender, user, showBan, extra);
                }
            });
        } else {
            this.showSeenMessage(server, sender, player, showBan, extra);
        }
    }

    private void showSeenMessage(Server server, CommandSource sender, User player, boolean showBan, boolean extra) throws Exception {
        if (player.getBase().isOnline() && this.canInteractWith(sender, player)) {
            this.seenOnline(server, sender, player, showBan, extra);
        } else {
            this.seenOffline(server, sender, player, showBan, extra);
        }
    }

    private void seenOnline(Server server, CommandSource sender, User user, boolean showBan, boolean extra) throws Exception {
        String location;
        List<String> history;
        user.setDisplayNick();
        sender.sendMessage(I18n.tl("seenOnline", user.getDisplayName(), DateUtil.formatDateDiff(user.getLastLogin())));
        if (this.ess.getSettings().isDebug()) {
            this.ess.getLogger().info("UUID: " + user.getBase().getUniqueId().toString());
        }
        if ((history = this.ess.getUserMap().getUserHistory(user.getBase().getUniqueId())) != null && history.size() > 1) {
            sender.sendMessage(I18n.tl("seenAccounts", StringUtil.joinListSkip(", ", user.getName(), history)));
        }
        if (user.isAfk()) {
            sender.sendMessage(I18n.tl("whoisAFK", I18n.tl("true", new Object[0])));
        }
        if (user.isJailed()) {
            sender.sendMessage(I18n.tl("whoisJail", user.getJailTimeout() > 0L ? DateUtil.formatDateDiff(user.getJailTimeout()) : I18n.tl("true", new Object[0])));
        }
        if (user.isMuted()) {
            sender.sendMessage(I18n.tl("whoisMuted", user.getMuteTimeout() > 0L ? DateUtil.formatDateDiff(user.getMuteTimeout()) : I18n.tl("true", new Object[0])));
        }
        if ((location = user.getGeoLocation()) != null && (!sender.isPlayer() || this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.geoip.show"))) {
            sender.sendMessage(I18n.tl("whoisGeoLocation", location));
        }
        if (extra) {
            sender.sendMessage(I18n.tl("whoisIPAddress", user.getBase().getAddress().getAddress().toString()));
        }
    }

    private void seenOffline(Server server, CommandSource sender, User user, boolean showBan, boolean extra) throws Exception {
        String location;
        List<String> history;
        user.setDisplayNick();
        if (user.getLastLogout() > 0L) {
            sender.sendMessage(I18n.tl("seenOffline", user.getName(), DateUtil.formatDateDiff(user.getLastLogout())));
        } else {
            sender.sendMessage(I18n.tl("userUnknown", user.getName()));
        }
        if (this.ess.getSettings().isDebug()) {
            this.ess.getLogger().info("UUID: " + user.getBase().getUniqueId().toString());
        }
        if ((history = this.ess.getUserMap().getUserHistory(user.getBase().getUniqueId())) != null && history.size() > 1) {
            sender.sendMessage(I18n.tl("seenAccounts", StringUtil.joinListSkip(", ", user.getName(), history)));
        }
        if (BanLookup.isBanned(this.ess, user).booleanValue()) {
            BanEntry banEntry = BanLookup.getBanEntry(this.ess, user.getName());
            String reason = showBan ? banEntry.getReason() : I18n.tl("true", new Object[0]);
            sender.sendMessage(I18n.tl("whoisBanned", reason));
            if (banEntry.getExpiration() != null) {
                Date expiry = banEntry.getExpiration();
                String expireString = I18n.tl("now", new Object[0]);
                if (expiry.after(new Date())) {
                    expireString = DateUtil.formatDateDiff(expiry.getTime());
                }
                sender.sendMessage(I18n.tl("whoisTempBanned", expireString));
            }
        }
        if ((location = user.getGeoLocation()) != null && (!sender.isPlayer() || this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.geoip.show"))) {
            sender.sendMessage(I18n.tl("whoisGeoLocation", location));
        }
        if (extra) {
            Location loc;
            if (!user.getLastLoginAddress().isEmpty()) {
                sender.sendMessage(I18n.tl("whoisIPAddress", user.getLastLoginAddress()));
            }
            if ((loc = user.getLogoutLocation()) != null) {
                sender.sendMessage(I18n.tl("whoisLocation", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
            }
        }
    }

    private void seenIP(Server server, final CommandSource sender, final String ipAddress) throws Exception {
        final UserMap userMap = this.ess.getUserMap();
        if (this.ess.getServer().getBanList(BanList.Type.IP).isBanned(ipAddress)) {
            sender.sendMessage(I18n.tl("isIpBanned", ipAddress));
        }
        sender.sendMessage(I18n.tl("runningPlayerMatch", ipAddress));
        this.ess.runTaskAsynchronously(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> matches = new ArrayList<String>();
                for (UUID u : userMap.getAllUniqueUsers()) {
                    String uIPAddress;
                    User user = Commandseen.this.ess.getUserMap().getUser(u);
                    if (user == null || (uIPAddress = user.getLastLoginAddress()).isEmpty() || !uIPAddress.equalsIgnoreCase(ipAddress)) continue;
                    matches.add(user.getName());
                }
                if (matches.size() > 0) {
                    sender.sendMessage(I18n.tl("matchingIPAddress", new Object[0]));
                    sender.sendMessage(StringUtil.joinList(matches));
                } else {
                    sender.sendMessage(I18n.tl("noMatchingPlayers", new Object[0]));
                }
            }
        });
    }
}

