/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Locale;
import net.ess3.api.IUser;
import net.ess3.api.events.NickChangeEvent;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Commandnick
extends EssentialsLoopCommand {
    public Commandnick() {
        super("nick");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        if (!this.ess.getSettings().changeDisplayName()) {
            throw new Exception(I18n.tl("nickDisplayName", new Object[0]));
        }
        if (args.length > 1 && user.isAuthorized("essentials.nick.others")) {
            String[] nickname = this.formatNickname(user, args[1]).split(" ");
            this.loopOfflinePlayers(server, user.getSource(), false, true, args[0], nickname);
            user.sendMessage(I18n.tl("nickChanged", new Object[0]));
        } else {
            String[] nickname = this.formatNickname(user, args[0]).split(" ");
            this.updatePlayer(server, user.getSource(), user, nickname);
        }
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        if (!this.ess.getSettings().changeDisplayName()) {
            throw new Exception(I18n.tl("nickDisplayName", new Object[0]));
        }
        String[] nickname = this.formatNickname(null, args[1]).split(" ");
        this.loopOfflinePlayers(server, sender, false, true, args[0], nickname);
        sender.sendMessage(I18n.tl("nickChanged", new Object[0]));
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User target, String[] args) throws NotEnoughArgumentsException {
        String nick = args[0];
        if (target.getName().equalsIgnoreCase(nick)) {
            String oldName = target.getDisplayName();
            this.setNickname(server, sender, target, nick);
            if (!target.getDisplayName().equalsIgnoreCase(oldName)) {
                target.sendMessage(I18n.tl("nickNoMore", new Object[0]));
            }
            target.sendMessage(I18n.tl("nickSet", target.getDisplayName()));
        } else if ("off".equalsIgnoreCase(nick)) {
            this.setNickname(server, sender, target, null);
            target.sendMessage(I18n.tl("nickNoMore", new Object[0]));
        } else {
            if (this.nickInUse(server, target, nick)) {
                throw new NotEnoughArgumentsException(I18n.tl("nickInUse", new Object[0]));
            }
            this.setNickname(server, sender, target, nick);
            target.sendMessage(I18n.tl("nickSet", target.getDisplayName()));
        }
    }

    private String formatNickname(User user, String nick) throws Exception {
        String newNick;
        String string = newNick = user == null ? FormatUtil.replaceFormat(nick) : FormatUtil.formatString(user, "essentials.nick", nick);
        if (!newNick.matches("^[a-zA-Z_0-9\u00a7]+$")) {
            throw new Exception(I18n.tl("nickNamesAlpha", new Object[0]));
        }
        if (this.getNickLength(newNick) > this.ess.getSettings().getMaxNickLength()) {
            throw new Exception(I18n.tl("nickTooLong", new Object[0]));
        }
        if (FormatUtil.stripFormat(newNick).length() < 1) {
            throw new Exception(I18n.tl("nickNamesAlpha", new Object[0]));
        }
        if (user != null && user.isAuthorized("essentials.nick.changecolors") && !user.isAuthorized("essentials.nick.changecolors.bypass") && !FormatUtil.stripFormat(newNick).equals(user.getName())) {
            throw new Exception(I18n.tl("nickNamesOnlyColorChanges", new Object[0]));
        }
        return newNick;
    }

    private int getNickLength(String nick) {
        return this.ess.getSettings().ignoreColorsInMaxLength() ? ChatColor.stripColor((String)nick).length() : nick.length();
    }

    private boolean nickInUse(Server server, User target, String nick) {
        String lowerNick = FormatUtil.stripFormat(nick.toLowerCase(Locale.ENGLISH));
        for (Player onlinePlayer : this.ess.getOnlinePlayers()) {
            String matchNick;
            if (target.getBase().getName().equals(onlinePlayer.getName()) || !lowerNick.equals((matchNick = FormatUtil.stripFormat(onlinePlayer.getDisplayName().replace(this.ess.getSettings().getNicknamePrefix(), ""))).toLowerCase(Locale.ENGLISH)) && !lowerNick.equals(onlinePlayer.getName().toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return this.ess.getUser(lowerNick) != null && this.ess.getUser(lowerNick) != target;
    }

    private void setNickname(Server server, CommandSource sender, User target, String nickname) {
        User controller = sender.isPlayer() ? this.ess.getUser(sender.getPlayer()) : null;
        NickChangeEvent nickEvent = new NickChangeEvent(controller, (IUser)target, nickname);
        server.getPluginManager().callEvent((Event)nickEvent);
        if (!nickEvent.isCancelled()) {
            target.setNickname(nickname);
            target.setDisplayNick();
        }
    }
}

