/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.placeholders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.deluxechat.ConfigWrapper;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.events.PlaceholderHookUnloadEvent;
import me.clip.deluxechat.events.RecipientPlaceholderHookUnloadEvent;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.DeluxeRecipientPlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderLayout;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;

public class PlaceholderHandler
implements Listener {
    private DeluxeChat plugin;
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("[%]([a-zA-Z0-9_.-@-]+)[%]");
    private static final Pattern RECIPIENT_PLACEHOLDER_PATTERN = Pattern.compile("[%](recipient_)([a-zA-Z0-9_.-@-]+)[%]");
    private static Map<String, DeluxePlaceholderHook> placeholders = new HashMap<String, DeluxePlaceholderHook>();
    private static Map<String, DeluxeRecipientPlaceholderHook> recipientPlaceholders = new HashMap<String, DeluxeRecipientPlaceholderHook>();
    private static Set<String> externalHooks = new HashSet<String>();
    private static Set<String> externalRecipientHooks = new HashSet<String>();
    private ConfigWrapper placeholderConfig;

    public PlaceholderHandler(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)deluxeChat);
        this.placeholderConfig = new ConfigWrapper(this.plugin, "", "placeholders.yml");
        this.placeholderConfig.createNewFile("Loading placeholders.yml", "Placeholders.yml file\nYou can create unique placeholder layouts depending on if a placeholder has\na value, or if it does not have a value.\nUse %value% to insert the original placeholder value into your format!\nTo create a placeholder layout, specify the placeholder with the following format:\n\n\nexample:\n\nlayouts:\n  <placeholder without %>:\n    has_value: '[%value%]'\n    no_value: '%value%'\n  'factions_faction':\n    has_value: '&8[&f%value%&8]'\n    no_value: '%value%'");
        this.loadLayouts();
    }

    public ConfigWrapper getPlaceholderConfig() {
        return this.placeholderConfig;
    }

    public void loadLayouts() {
        FileConfiguration fileConfiguration = this.placeholderConfig.getConfig();
        if (fileConfiguration.getConfigurationSection("layouts") != null) {
            Set set = fileConfiguration.getConfigurationSection("layouts").getKeys(false);
            if (set == null || set.isEmpty()) {
                return;
            }
            for (String string : set) {
                String string2 = fileConfiguration.getString("layouts." + string + ".has_value");
                String string3 = fileConfiguration.getString("layouts." + string + ".no_value");
                if (string2 == null || string3 == null) continue;
                PlaceholderLayout placeholderLayout = new PlaceholderLayout(string, string2, string3);
                placeholderLayout.load();
            }
        } else {
            fileConfiguration.set("layouts.placeholder_here.has_value", (Object)"&8[%value%&8]");
            fileConfiguration.set("layouts.placeholder_here.no_value", (Object)"%value%");
            this.placeholderConfig.saveConfig();
            this.placeholderConfig.reloadConfig();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPluginUnload(PluginDisableEvent pluginDisableEvent) {
        String string = pluginDisableEvent.getPlugin().getName();
        if (string != null && !string.equals(this.plugin.getName())) {
            if (PlaceholderHandler.unregisterPlaceholderHook(string)) {
                this.plugin.getLogger().info("Unregistered placeholder hook to: " + string);
            }
            if (PlaceholderHandler.unregisterRecipientPlaceholderHook(string)) {
                this.plugin.getLogger().info("Unregistered recipient placeholder hook to: " + string);
            }
        }
    }

    public static void unregisterInternalPlaceholderHooks() {
        Set<String> set = PlaceholderHandler.getRegisteredPlaceholderPlugins();
        Set<String> set2 = PlaceholderHandler.getExternalPlaceholderPlugins();
        for (String string : set) {
            if (set2.contains(string)) continue;
            PlaceholderHandler.unregisterPlaceholderHook(string);
        }
    }

    public static void unregisterInternalRecipientPlaceholderHooks() {
        Set<String> set = PlaceholderHandler.getRegisteredRecipientPlaceholderPlugins();
        Set<String> set2 = PlaceholderHandler.getExternalRecipientPlaceholderPlugins();
        for (String string : set) {
            if (set2.contains(string)) continue;
            PlaceholderHandler.unregisterRecipientPlaceholderHook(string);
        }
    }

    public static Set<String> getExternalPlaceholderPlugins() {
        if (externalHooks == null || externalHooks.isEmpty()) {
            return new HashSet<String>();
        }
        return new HashSet<String>(externalHooks);
    }

    public static Set<String> getExternalRecipientPlaceholderPlugins() {
        if (externalRecipientHooks == null || externalRecipientHooks.isEmpty()) {
            return new HashSet<String>();
        }
        return new HashSet<String>(externalRecipientHooks);
    }

    public static boolean registerPlaceholderHook(Plugin plugin, DeluxePlaceholderHook deluxePlaceholderHook) {
        if (plugin == null) {
            return false;
        }
        return PlaceholderHandler.registerPlaceholderHook(plugin.getName(), deluxePlaceholderHook, false);
    }

    public static boolean registerPlaceholderHook(String string, DeluxePlaceholderHook deluxePlaceholderHook) {
        if (string == null || deluxePlaceholderHook == null) {
            return false;
        }
        return PlaceholderHandler.registerPlaceholderHook(string, deluxePlaceholderHook, false);
    }

    public static boolean registerPlaceholderHook(Plugin plugin, DeluxePlaceholderHook deluxePlaceholderHook, boolean bl) {
        if (plugin == null || deluxePlaceholderHook == null) {
            return false;
        }
        return PlaceholderHandler.registerPlaceholderHook(plugin.getName(), deluxePlaceholderHook, bl);
    }

    public static boolean registerPlaceholderHook(String string, DeluxePlaceholderHook deluxePlaceholderHook, boolean bl) {
        if (placeholders == null) {
            placeholders = new HashMap<String, DeluxePlaceholderHook>();
        }
        if (string == null || deluxePlaceholderHook == null) {
            return false;
        }
        if (placeholders.containsKey(string = string.toLowerCase())) {
            return false;
        }
        if (!bl) {
            if (externalHooks == null) {
                externalHooks = new HashSet<String>();
            }
            if (!externalHooks.contains(string)) {
                externalHooks.add(string);
            }
        }
        placeholders.put(string, deluxePlaceholderHook);
        return true;
    }

    public static boolean registerRecipientPlaceholderHook(Plugin plugin, DeluxeRecipientPlaceholderHook deluxeRecipientPlaceholderHook) {
        if (plugin == null || deluxeRecipientPlaceholderHook == null) {
            return false;
        }
        return PlaceholderHandler.registerRecipientPlaceholderHook(plugin.getName(), deluxeRecipientPlaceholderHook, false);
    }

    public static boolean registerRecipientPlaceholderHook(String string, DeluxeRecipientPlaceholderHook deluxeRecipientPlaceholderHook) {
        if (string == null || deluxeRecipientPlaceholderHook == null) {
            return false;
        }
        return PlaceholderHandler.registerRecipientPlaceholderHook(string, deluxeRecipientPlaceholderHook, false);
    }

    public static boolean registerRecipientPlaceholderHook(Plugin plugin, DeluxeRecipientPlaceholderHook deluxeRecipientPlaceholderHook, boolean bl) {
        if (plugin == null || deluxeRecipientPlaceholderHook == null) {
            return false;
        }
        return PlaceholderHandler.registerRecipientPlaceholderHook(plugin.getName(), deluxeRecipientPlaceholderHook, bl);
    }

    public static boolean registerRecipientPlaceholderHook(String string, DeluxeRecipientPlaceholderHook deluxeRecipientPlaceholderHook, boolean bl) {
        if (recipientPlaceholders == null) {
            recipientPlaceholders = new HashMap<String, DeluxeRecipientPlaceholderHook>();
        }
        if (string == null || deluxeRecipientPlaceholderHook == null) {
            return false;
        }
        if (recipientPlaceholders.containsKey(string = string.toLowerCase())) {
            return false;
        }
        if (!bl) {
            if (externalRecipientHooks == null) {
                externalRecipientHooks = new HashSet<String>();
            }
            if (!externalRecipientHooks.contains(string)) {
                externalRecipientHooks.add(string);
            }
        }
        recipientPlaceholders.put(string, deluxeRecipientPlaceholderHook);
        return true;
    }

    public static boolean unregisterPlaceholderHook(Plugin plugin) {
        if (plugin == null) {
            return false;
        }
        return PlaceholderHandler.unregisterPlaceholderHook(plugin.getName());
    }

    public static boolean unregisterPlaceholderHook(String string) {
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        if (placeholders == null || placeholders.isEmpty()) {
            return false;
        }
        if (placeholders.containsKey(string)) {
            PlaceholderHookUnloadEvent placeholderHookUnloadEvent = new PlaceholderHookUnloadEvent(string);
            Bukkit.getPluginManager().callEvent((Event)placeholderHookUnloadEvent);
            if (!placeholderHookUnloadEvent.isCancelled()) {
                if (externalHooks != null && externalHooks.contains(string)) {
                    externalHooks.remove(string);
                }
                return placeholders.remove(string) != null;
            }
        }
        return false;
    }

    public static boolean unregisterRecipientPlaceholderHook(Plugin plugin) {
        if (plugin == null) {
            return false;
        }
        return PlaceholderHandler.unregisterRecipientPlaceholderHook(plugin.getName());
    }

    public static boolean unregisterRecipientPlaceholderHook(String string) {
        if (string == null) {
            return false;
        }
        if (recipientPlaceholders == null || recipientPlaceholders.isEmpty()) {
            return false;
        }
        if (recipientPlaceholders.containsKey(string)) {
            RecipientPlaceholderHookUnloadEvent recipientPlaceholderHookUnloadEvent = new RecipientPlaceholderHookUnloadEvent(string);
            Bukkit.getPluginManager().callEvent((Event)recipientPlaceholderHookUnloadEvent);
            if (!recipientPlaceholderHookUnloadEvent.isCancelled()) {
                if (externalRecipientHooks != null && externalRecipientHooks.contains(string)) {
                    externalRecipientHooks.remove(string);
                }
                return recipientPlaceholders.remove(string) != null;
            }
        }
        return false;
    }

    public static Set<String> getRegisteredPlaceholderPlugins() {
        if (placeholders == null || placeholders.isEmpty()) {
            return new HashSet<String>();
        }
        return new HashSet<String>(placeholders.keySet());
    }

    public static Set<String> getRegisteredRecipientPlaceholderPlugins() {
        if (recipientPlaceholders == null || recipientPlaceholders.isEmpty()) {
            return new HashSet<String>();
        }
        return new HashSet<String>(recipientPlaceholders.keySet());
    }

    public static void unregisterAllPlaceholderHooks() {
        HashSet<String> hashSet;
        if (placeholders != null) {
            hashSet = new HashSet<String>(placeholders.keySet());
            for (String string : hashSet) {
                PlaceholderHandler.unregisterPlaceholderHook(string);
            }
            hashSet = null;
        }
        if (recipientPlaceholders != null) {
            hashSet = new HashSet<String>(recipientPlaceholders.keySet());
            for (String string : hashSet) {
                PlaceholderHandler.unregisterRecipientPlaceholderHook(string);
            }
            hashSet = null;
        }
    }

    public void unregisterAll() {
        recipientPlaceholders = null;
        placeholders = null;
    }

    public static Map<String, DeluxePlaceholderHook> getPlaceholders() {
        return new HashMap<String, DeluxePlaceholderHook>(placeholders);
    }

    public static Map<String, DeluxeRecipientPlaceholderHook> getRecipientPlaceholders() {
        return new HashMap<String, DeluxeRecipientPlaceholderHook>(recipientPlaceholders);
    }

    public static List<String> setPlaceholders(Player player, List<String> list) {
        if (list == null) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(ChatColor.translateAlternateColorCodes((char)'&', (String)PlaceholderHandler.setPlaceholders(player, string)));
        }
        return arrayList;
    }

    public static String setPlaceholders(Player player, String string) {
        if (string == null || placeholders == null || placeholders.isEmpty()) {
            return string;
        }
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = string2.toCharArray();
            int n = 0;
            while (n < cArray.length) {
                if (cArray[n] == '_') break;
                stringBuilder.append(cArray[n]);
                ++n;
            }
            String string3 = stringBuilder.toString();
            StringBuilder stringBuilder2 = new StringBuilder();
            int n2 = n + 1;
            while (n2 < cArray.length) {
                stringBuilder2.append(cArray[n2]);
                ++n2;
            }
            String string4 = stringBuilder2.toString();
            if (string4.isEmpty()) {
                string4 = string3;
            }
            for (String string5 : PlaceholderHandler.getRegisteredPlaceholderPlugins()) {
                String string6;
                if (!string3.equalsIgnoreCase(string5) || (string6 = PlaceholderHandler.getPlaceholders().get(string5).onPlaceholderRequest(player, string4)) == null) continue;
                PlaceholderLayout placeholderLayout = PlaceholderLayout.getLayout(string2);
                if (placeholderLayout == null) {
                    string = string.replaceAll("%" + string2 + "%", Matcher.quoteReplacement(string6));
                    continue;
                }
                if (string6.isEmpty()) {
                    string6 = placeholderLayout.getNoValue().replace("%value%", "");
                    string = string.replaceAll("%" + string2 + "%", Matcher.quoteReplacement(string6));
                    continue;
                }
                String string7 = placeholderLayout.getHasValue().replace("%value%", string6);
                string = string.replaceAll("%" + string2 + "%", Matcher.quoteReplacement(string7));
            }
        }
        return string;
    }

    public static List<String> setRecipientPlaceholders(Player player, Player player2, List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(ChatColor.translateAlternateColorCodes((char)'&', (String)PlaceholderHandler.setRecipientPlaceholders(player, player2, string)));
        }
        return arrayList;
    }

    public static List<String> setPMRecipientPlaceholders(Player player, List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(ChatColor.translateAlternateColorCodes((char)'&', (String)PlaceholderHandler.setPMRecipientPlaceholders(player, string)));
        }
        return arrayList;
    }

    public static String setPMRecipientPlaceholders(Player player, String string) {
        if (string == null || placeholders == null || placeholders.isEmpty()) {
            return string;
        }
        Matcher matcher = RECIPIENT_PLACEHOLDER_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(2);
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = string2.toCharArray();
            int n = 0;
            while (n < cArray.length) {
                if (cArray[n] == '_') break;
                stringBuilder.append(cArray[n]);
                ++n;
            }
            String string3 = stringBuilder.toString();
            StringBuilder stringBuilder2 = new StringBuilder();
            int n2 = n + 1;
            while (n2 < cArray.length) {
                stringBuilder2.append(cArray[n2]);
                ++n2;
            }
            String string4 = stringBuilder2.toString();
            if (string4.isEmpty()) {
                string4 = string3;
            }
            for (String string5 : PlaceholderHandler.getRegisteredPlaceholderPlugins()) {
                String string6;
                if (!string3.equalsIgnoreCase(string5) || (string6 = PlaceholderHandler.getPlaceholders().get(string5).onPlaceholderRequest(player, string4)) == null) continue;
                PlaceholderLayout placeholderLayout = PlaceholderLayout.getLayout(string2);
                if (placeholderLayout == null) {
                    string = string.replaceAll("%recipient_" + string2 + "%", Matcher.quoteReplacement(string6));
                    continue;
                }
                if (string6.isEmpty()) {
                    string6 = placeholderLayout.getNoValue().replace("%value%", "");
                    string = string.replaceAll("%recipient_" + string2 + "%", Matcher.quoteReplacement(string6));
                    continue;
                }
                String string7 = placeholderLayout.getHasValue().replace("%value%", string6);
                string = string.replaceAll("%recipient_" + string2 + "%", Matcher.quoteReplacement(string7));
            }
        }
        return string;
    }

    public static String setRecipientPlaceholders(Player player, Player player2, String string) {
        if (string == null || recipientPlaceholders == null || recipientPlaceholders.isEmpty()) {
            return string;
        }
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = string2.toCharArray();
            int n = 0;
            while (n < cArray.length) {
                if (cArray[n] == '_') break;
                stringBuilder.append(cArray[n]);
                ++n;
            }
            String string3 = stringBuilder.toString();
            StringBuilder stringBuilder2 = new StringBuilder();
            int n2 = n + 1;
            while (n2 < cArray.length) {
                stringBuilder2.append(cArray[n2]);
                ++n2;
            }
            String string4 = stringBuilder2.toString();
            if (string4.isEmpty()) {
                string4 = string3;
            }
            for (String string5 : PlaceholderHandler.getRegisteredRecipientPlaceholderPlugins()) {
                String string6;
                if (!string3.equalsIgnoreCase(string5) || (string6 = PlaceholderHandler.getRecipientPlaceholders().get(string5).onRecipientPlaceholderRequest(player, player2, string4)) == null) continue;
                PlaceholderLayout placeholderLayout = PlaceholderLayout.getLayout(string2);
                if (placeholderLayout == null) {
                    string = string.replaceAll("%" + string2 + "%", Matcher.quoteReplacement(string6));
                    continue;
                }
                if (string6.isEmpty()) {
                    string6 = placeholderLayout.getNoValue().replace("%value%", "");
                    string = string.replaceAll("%" + string2 + "%", Matcher.quoteReplacement(string6));
                    continue;
                }
                String string7 = placeholderLayout.getHasValue().replace("%value%", string6);
                string = string.replaceAll("%" + string2 + "%", Matcher.quoteReplacement(string7));
            }
        }
        return string;
    }
}

