/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.listeners;

import java.util.Set;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.DeluxeUtil;
import me.clip.deluxechat.Lang;
import me.clip.deluxechat.events.DeluxeChatEvent;
import me.clip.deluxechat.events.DeluxeChatJSONEvent;
import me.clip.deluxechat.events.RecipientPlaceholderEvent;
import me.clip.deluxechat.fanciful.FancyMessage;
import me.clip.deluxechat.objects.DeluxeFormat;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class AsyncPlayerChatListener
implements Listener {
    private DeluxeChat plugin;

    public AsyncPlayerChatListener(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onChhat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        Player player = asyncPlayerChatEvent.getPlayer();
        if (this.plugin.isMuted(player)) {
            asyncPlayerChatEvent.setCancelled(true);
            return;
        }
        String string = asyncPlayerChatEvent.getMessage();
        if (DeluxeUtil.containsInvalidChars(string) && !player.hasPermission("deluxechat.utf")) {
            DeluxeUtil.sms(player, Lang.CHAT_ILLEGAL_CHARACTERS.getConfigValue(null));
            asyncPlayerChatEvent.setCancelled(true);
            return;
        }
        if (!player.hasPermission("deluxechat.filter.bypass")) {
            string = DeluxeUtil.removeBlacklisted(string);
        }
        string = DeluxeUtil.checkColor(player, string, false);
        asyncPlayerChatEvent.setMessage(string);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (DeluxeChat.getFormats() == null || DeluxeChat.getFormats().isEmpty()) {
            return;
        }
        Player player = asyncPlayerChatEvent.getPlayer();
        String string = asyncPlayerChatEvent.getMessage();
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        DeluxeFormat deluxeFormat = DeluxeFormat.newInstance(this.plugin.getPlayerFormat(player));
        DeluxeChatEvent deluxeChatEvent = new DeluxeChatEvent(player, asyncPlayerChatEvent.getRecipients(), deluxeFormat, string);
        Bukkit.getPluginManager().callEvent((Event)deluxeChatEvent);
        if (deluxeChatEvent.isCancelled()) {
            asyncPlayerChatEvent.setCancelled(true);
            return;
        }
        deluxeFormat = deluxeChatEvent.getDeluxeFormat();
        FancyMessage fancyMessage = this.plugin.getFancyChatFormat(player, deluxeFormat);
        if (fancyMessage == null) {
            this.plugin.log.severe("There was an error getting the chat format for player" + player.getName());
            return;
        }
        Set<Player> set = deluxeChatEvent.getRecipients();
        if (set == null) {
            fancyMessage = null;
            asyncPlayerChatEvent.setCancelled(true);
            return;
        }
        String string2 = String.valueOf(fancyMessage.getLastColor()) + fancyMessage.getChatColor() + deluxeChatEvent.getChatMessage();
        boolean bl = DeluxeChat.useRelationPlaceholders();
        String string3 = this.plugin.getChat().convertMsg(player, string2);
        if (bl) {
            DeluxeChatJSONEvent deluxeChatJSONEvent = new DeluxeChatJSONEvent(player, fancyMessage.toJSONString(), string3, string2);
            Bukkit.getPluginManager().callEvent((Event)deluxeChatJSONEvent);
            if (deluxeChatJSONEvent.getJSONFormat() == null || deluxeChatJSONEvent.getJSONChatMessage() == null || deluxeChatJSONEvent.getJSONFormat().isEmpty()) {
                return;
            }
            for (Player object : set) {
                this.plugin.getChat().sendDirectChat(player, deluxeChatJSONEvent.getJSONFormat(), deluxeChatJSONEvent.getJSONChatMessage(), player, object);
            }
        } else {
            this.plugin.getChat().sendDeluxeChat(player, fancyMessage.toJSONString(), string3, set);
        }
        set.clear();
        asyncPlayerChatEvent.getRecipients().clear();
        if (DeluxeChat.useBungee() && !DeluxeChat.isLocal(player.getUniqueId().toString()) && player.hasPermission("deluxechat.bungee.chat")) {
            boolean bl2 = player.hasPermission("deluxechat.bungee.override");
            if (bl) {
                RecipientPlaceholderEvent recipientPlaceholderEvent = new RecipientPlaceholderEvent(player, player, fancyMessage.toJSONString(), string3, true);
                Bukkit.getPluginManager().callEvent((Event)recipientPlaceholderEvent);
                if (recipientPlaceholderEvent.getJSONFormat() == null || recipientPlaceholderEvent.getChatMessage() == null || recipientPlaceholderEvent.getJSONFormat().isEmpty() || recipientPlaceholderEvent.getChatMessage().isEmpty()) {
                    return;
                }
                DeluxeChat.forwardString(player, recipientPlaceholderEvent.getJSONFormat(), recipientPlaceholderEvent.getChatMessage(), bl2);
            } else {
                DeluxeChat.forwardString(player, fancyMessage.toJSONString(), string3, bl2);
            }
        }
    }
}

