/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import com.mooglemods.wickedskywars.controllers.PlayerController;
import com.mooglemods.wickedskywars.player.GamePlayer;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class WickedSkywarsHook
implements DeluxeHook {
    DeluxeChat plugin;

    public WickedSkywarsHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @Override
    public void hook() {
        boolean bl;
        if (Bukkit.getPluginManager().isPluginEnabled("WickedSkyWars") && (bl = PlaceholderHandler.registerPlaceholderHook("WickedSkyWars", new DeluxePlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player player, String string) {
                switch (string) {
                    case "score": {
                        return WickedSkywarsHook.this.getScore(player);
                    }
                    case "kills": {
                        return WickedSkywarsHook.this.getKills(player);
                    }
                    case "deaths": {
                        return WickedSkywarsHook.this.getDeaths(player);
                    }
                    case "played": 
                    case "gamesplayed": {
                        return WickedSkywarsHook.this.getGamesPlayed(player);
                    }
                    case "gameswon": 
                    case "won": {
                        return WickedSkywarsHook.this.getGamesWon(player);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into WickedSkyWars for placeholders!");
        }
    }

    private String getScore(Player player) {
        GamePlayer gamePlayer = PlayerController.get().get(player);
        if (gamePlayer == null) {
            return "0";
        }
        return String.valueOf(gamePlayer.getScore());
    }

    private String getKills(Player player) {
        GamePlayer gamePlayer = PlayerController.get().get(player);
        if (gamePlayer == null) {
            return "0";
        }
        return String.valueOf(gamePlayer.getKills());
    }

    private String getDeaths(Player player) {
        GamePlayer gamePlayer = PlayerController.get().get(player);
        if (gamePlayer == null) {
            return "0";
        }
        return String.valueOf(gamePlayer.getDeaths());
    }

    private String getGamesPlayed(Player player) {
        GamePlayer gamePlayer = PlayerController.get().get(player);
        if (gamePlayer == null) {
            return "0";
        }
        return String.valueOf(gamePlayer.getGamesPlayed());
    }

    private String getGamesWon(Player player) {
        GamePlayer gamePlayer = PlayerController.get().get(player);
        if (gamePlayer == null) {
            return "0";
        }
        return String.valueOf(gamePlayer.getGamesWon());
    }
}

