/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import java.util.UUID;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import teozfrank.ultimatevotes.util.UltimateVotesAPI;

public class UltimateVotesHook
implements DeluxeHook {
    DeluxeChat plugin;

    public UltimateVotesHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @Override
    public void hook() {
        boolean bl;
        if (Bukkit.getPluginManager().isPluginEnabled("UltimateVotes") && (bl = PlaceholderHandler.registerPlaceholderHook("UltimateVotes", new DeluxePlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player player, String string) {
                switch (string) {
                    case "monthlyvotes": {
                        return UltimateVotesHook.this.getMonthly(player);
                    }
                    case "totalvotes": {
                        return UltimateVotesHook.this.getTotal(player);
                    }
                    case "hasvoted": {
                        return UltimateVotesHook.this.hasVoted(player);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into UltimateVotes for placeholders!");
        }
    }

    private String getMonthly(Player player) {
        return String.valueOf(UltimateVotesAPI.getPlayerMonthlyVotes((UUID)player.getUniqueId()));
    }

    private String getTotal(Player player) {
        return String.valueOf(UltimateVotesAPI.getPlayerTotalVotes((UUID)player.getUniqueId()));
    }

    private String hasVoted(Player player) {
        if (UltimateVotesAPI.hasVotedToday((UUID)player.getUniqueId())) {
            return "&aYes";
        }
        return "&cNo";
    }
}

