/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import com.walrusone.skywars.SkyWarsReloaded;
import com.walrusone.skywars.game.GamePlayer;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SkyWarsReloadedHook
implements DeluxeHook {
    DeluxeChat plugin;

    public SkyWarsReloadedHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @Override
    public void hook() {
        boolean bl;
        if (Bukkit.getPluginManager().isPluginEnabled("SkyWarsReloaded") && SkyWarsReloaded.getPC() != null && (bl = PlaceholderHandler.registerPlaceholderHook("SkyWarsReloaded", new DeluxePlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player player, String string) {
                GamePlayer gamePlayer = SkyWarsReloaded.getPC().getPlayer(player.getUniqueId());
                if (gamePlayer == null) {
                    return "";
                }
                switch (string) {
                    case "blocks": {
                        return String.valueOf(gamePlayer.getBlocks());
                    }
                    case "kills": {
                        return String.valueOf(gamePlayer.getKills());
                    }
                    case "deaths": {
                        return String.valueOf(gamePlayer.getDeaths());
                    }
                    case "games": 
                    case "games_played": {
                        return String.valueOf(gamePlayer.getGamesPlayed());
                    }
                    case "op_vote": 
                    case "opvote": {
                        return String.valueOf(gamePlayer.getOpVote());
                    }
                    case "score": {
                        return String.valueOf(gamePlayer.getScore());
                    }
                    case "timevote": 
                    case "time_vote": {
                        return String.valueOf(gamePlayer.getTimeVote());
                    }
                    case "wins": {
                        return String.valueOf(gamePlayer.getWins());
                    }
                    case "selected_kit": {
                        return gamePlayer.getSelectedKit() != null ? gamePlayer.getSelectedKit().getKitName() : "";
                    }
                    case "map_name": {
                        return gamePlayer.getGame() != null ? gamePlayer.getGame().getMapName() : "";
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.getLogger().info("Successfully hooked into SkyWarsReloaded for placeholders!");
        }
    }
}

