/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import net.sacredlabyrinth.phaed.simpleclans.Clan;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.managers.ClanManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SimpleClansHook
implements DeluxeHook {
    private DeluxeChat plugin;
    private ClanManager clanManager;

    public SimpleClansHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @Override
    public void hook() {
        SimpleClans simpleClans;
        if (Bukkit.getPluginManager().isPluginEnabled("SimpleClans") && (simpleClans = (SimpleClans)Bukkit.getPluginManager().getPlugin("SimpleClans")) != null) {
            boolean bl;
            this.clanManager = simpleClans.getClanManager();
            if (this.clanManager != null && (bl = PlaceholderHandler.registerPlaceholderHook((Plugin)simpleClans, new DeluxePlaceholderHook(){

                @Override
                public String onPlaceholderRequest(Player player, String string) {
                    ClanPlayer clanPlayer = SimpleClansHook.this.clanManager.getClanPlayer(player);
                    if (clanPlayer == null) {
                        return "";
                    }
                    switch (string) {
                        case "in_clan": {
                            return clanPlayer.getClan() != null ? DeluxeChat.getBooleanTrue() : DeluxeChat.getBooleanFalse();
                        }
                        case "join_date": {
                            return clanPlayer.getJoinDateString();
                        }
                        case "rank": {
                            return clanPlayer.getRank();
                        }
                        case "tag": {
                            return clanPlayer.getTag();
                        }
                        case "tag_label": {
                            return clanPlayer.getTagLabel();
                        }
                        case "civilian_kills": {
                            return String.valueOf(clanPlayer.getCivilianKills());
                        }
                        case "deaths": {
                            return String.valueOf(clanPlayer.getDeaths());
                        }
                        case "kdr": {
                            return String.valueOf(clanPlayer.getKDR());
                        }
                        case "neutral_kills": {
                            return String.valueOf(clanPlayer.getNeutralKills());
                        }
                        case "rival_kills": {
                            return String.valueOf(clanPlayer.getRivalKills());
                        }
                        case "weighted_kills": {
                            return String.valueOf(clanPlayer.getWeightedKills());
                        }
                        case "is_leader": {
                            return clanPlayer.isLeader() ? DeluxeChat.getBooleanTrue() : DeluxeChat.getBooleanFalse();
                        }
                    }
                    if (clanPlayer.getClan() == null) {
                        return "";
                    }
                    Clan clan = clanPlayer.getClan();
                    switch (string) {
                        case "clan_tag": {
                            return clan.getTag();
                        }
                        case "clan_color_tag": {
                            return clan.getColorTag();
                        }
                        case "clan_founded_string": {
                            return clan.getFoundedString();
                        }
                        case "clan_name": {
                            return clan.getName();
                        }
                        case "clan_average_wk": {
                            return String.valueOf(clan.getAverageWK());
                        }
                        case "clan_balance": {
                            return String.valueOf(clan.getBalance());
                        }
                        case "clan_size": {
                            return String.valueOf(clan.getSize());
                        }
                        case "clan_total_civilian": {
                            return String.valueOf(clan.getTotalCivilian());
                        }
                        case "clan_total_deaths": {
                            return String.valueOf(clan.getTotalDeaths());
                        }
                        case "clan_total_kdr": {
                            return String.valueOf(clan.getTotalKDR());
                        }
                        case "clan_total_neutral": {
                            return String.valueOf(clan.getTotalNeutral());
                        }
                        case "clan_total_rival": {
                            return String.valueOf(clan.getTotalRival());
                        }
                        case "clan_friendly_fire": {
                            return clan.isFriendlyFire() ? DeluxeChat.getBooleanTrue() : DeluxeChat.getBooleanFalse();
                        }
                        case "clan_allow_deposit": {
                            return clan.isAllowDeposit() ? DeluxeChat.getBooleanTrue() : DeluxeChat.getBooleanFalse();
                        }
                        case "clan_allow_withdraw": {
                            return clan.isAllowWithdraw() ? DeluxeChat.getBooleanTrue() : DeluxeChat.getBooleanFalse();
                        }
                        case "clan_is_unrivable": {
                            return clan.isUnrivable() ? DeluxeChat.getBooleanTrue() : DeluxeChat.getBooleanFalse();
                        }
                        case "clan_leader_size": {
                            return String.valueOf(clan.getLeaders().size());
                        }
                    }
                    return null;
                }
            }, true))) {
                this.plugin.log.info("Hooked into SimpleClans for placeholders!");
            }
        }
    }
}

