/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import net.slipcor.pvpstats.PVPData;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PvPStatsHook
implements DeluxeHook {
    DeluxeChat plugin;

    public PvPStatsHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @Override
    public void hook() {
        boolean bl;
        if (Bukkit.getPluginManager().isPluginEnabled("pvpstats") && (bl = PlaceholderHandler.registerPlaceholderHook("pvpstats", new DeluxePlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player player, String string) {
                switch (string) {
                    case "kills": {
                        return PvPStatsHook.this.getKills(player);
                    }
                    case "deaths": {
                        return PvPStatsHook.this.getDeaths(player);
                    }
                    case "elo": {
                        return PvPStatsHook.this.getElo(player);
                    }
                    case "killstreak": {
                        return PvPStatsHook.this.getStreak(player);
                    }
                    case "maxstreak": {
                        return PvPStatsHook.this.getMaxStreak(player);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into pvpstats for placeholders!");
        }
    }

    private String getKills(Player player) {
        return String.valueOf(PVPData.getKills((String)player.getName()));
    }

    private String getDeaths(Player player) {
        return String.valueOf(PVPData.getDeaths((String)player.getName()));
    }

    private String getElo(Player player) {
        return String.valueOf(PVPData.getEloScore((String)player.getName()));
    }

    private String getStreak(Player player) {
        return String.valueOf(PVPData.getStreak((String)player.getName()));
    }

    private String getMaxStreak(Player player) {
        return String.valueOf(PVPData.getMaxStreak((String)player.getName()));
    }
}

