/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import com.intellectualcrafters.plot.object.PlotPlayer;
import com.intellectualcrafters.plot.util.UUIDHandler;
import java.util.HashSet;
import java.util.UUID;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlotSquaredHook
implements DeluxeHook {
    private DeluxeChat plugin;

    public PlotSquaredHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @Override
    public void hook() {
        boolean bl;
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlotSquared") && (bl = PlaceholderHandler.registerPlaceholderHook("PlotSquared", new DeluxePlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player player, String string) {
                if (player == null) {
                    return "";
                }
                PlotPlayer plotPlayer = PlotPlayer.get((String)player.getName());
                if (plotPlayer == null) {
                    return "";
                }
                switch (string) {
                    case "currentplot_alias": {
                        return plotPlayer.getCurrentPlot() != null ? plotPlayer.getCurrentPlot().getAlias() : "";
                    }
                    case "currentplot_owner": {
                        if (plotPlayer.getCurrentPlot() != null) {
                            HashSet hashSet = plotPlayer.getCurrentPlot().getOwners();
                            if (hashSet == null || hashSet.isEmpty()) {
                                return "";
                            }
                            UUID uUID = (UUID)hashSet.toArray()[0];
                            if (uUID == null) {
                                return "";
                            }
                            String string2 = UUIDHandler.getName((UUID)uUID);
                            return string2 != null ? string2 : (Bukkit.getOfflinePlayer((UUID)uUID) != null ? Bukkit.getOfflinePlayer((UUID)uUID).getName() : "unknown");
                        }
                        return "";
                    }
                    case "currentplot_members_size": {
                        if (plotPlayer.getCurrentPlot() == null) {
                            return "0";
                        }
                        return String.valueOf(plotPlayer.getCurrentPlot().getMembers().size());
                    }
                    case "currentplot_world": {
                        return player.getWorld().getName();
                    }
                    case "has_plot": {
                        return plotPlayer.getPlotCount() > 0 ? DeluxeChat.getBooleanTrue() : DeluxeChat.getBooleanFalse();
                    }
                    case "has_build_rights": {
                        return plotPlayer.getCurrentPlot() != null ? (plotPlayer.getCurrentPlot().getMembers().contains(plotPlayer.getUUID()) || plotPlayer.getCurrentPlot().getOwners().contains(plotPlayer.getUUID()) ? DeluxeChat.getBooleanTrue() : DeluxeChat.getBooleanFalse()) : "";
                    }
                    case "plot_count": {
                        return String.valueOf(plotPlayer.getPlotCount());
                    }
                    case "allowed_plot_count": {
                        return String.valueOf(plotPlayer.getAllowedPlots());
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into PlotSquared for placeholders!");
        }
    }
}

