/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import com.gmail.nossr50.api.ExperienceAPI;
import com.gmail.nossr50.api.PartyAPI;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.util.player.UserManager;
import java.util.UUID;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class McMMOHook
implements DeluxeHook {
    private DeluxeChat plugin;

    public McMMOHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @Override
    public void hook() {
        boolean bl;
        if (Bukkit.getPluginManager().isPluginEnabled("mcMMO") && (bl = PlaceholderHandler.registerPlaceholderHook("mcmmo", new DeluxePlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player player, String string) {
                if (player == null) {
                    return "";
                }
                McMMOPlayer mcMMOPlayer = null;
                try {
                    mcMMOPlayer = UserManager.getPlayer((Player)player);
                }
                catch (Exception exception) {
                    return "";
                }
                if (mcMMOPlayer == null) {
                    return "";
                }
                if (string.startsWith("level_")) {
                    String string2 = string.split("level_")[1];
                    return McMMOHook.this.getSkillLevel(mcMMOPlayer, string2);
                }
                if (string.startsWith("rank_")) {
                    String string3 = string.split("rank_")[1];
                    return McMMOHook.this.getSkillRank(player, string3);
                }
                if (string.startsWith("xp_remaining_")) {
                    String string4 = string.split("xp_remaining_")[1];
                    return McMMOHook.this.getXPRemaining(player, string4);
                }
                if (string.startsWith("xp_needed_")) {
                    String string5 = string.split("xp_needed_")[1];
                    return McMMOHook.this.getXPToNextLevel(player, string5);
                }
                if (string.startsWith("xp_")) {
                    String string6 = string.split("xp_")[1];
                    return McMMOHook.this.getSkillXP(player, string6);
                }
                switch (string) {
                    case "power_level": {
                        return String.valueOf(mcMMOPlayer.getPowerLevel());
                    }
                    case "power_level_cap": {
                        return String.valueOf(ExperienceAPI.getPowerLevelCap());
                    }
                    case "in_party": {
                        return PartyAPI.inParty((Player)player) ? "yes" : "no";
                    }
                    case "party_name": {
                        return PartyAPI.getPartyName((Player)player) != null ? PartyAPI.getPartyName((Player)player) : "";
                    }
                    case "party_leader": {
                        return McMMOHook.this.getPartyLeader(player);
                    }
                    case "is_party_leader": {
                        return McMMOHook.this.getPartyLeader(player).equals(player.getName()) ? "yes" : "no";
                    }
                    case "party_size": {
                        return PartyAPI.getMembersMap((Player)player) != null ? String.valueOf(PartyAPI.getMembersMap((Player)player).size()) : "0";
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.getLogger().info("Hooked into mcMMO for placeholders!");
        }
    }

    private String getPartyLeader(Player player) {
        if (PartyAPI.getPartyName((Player)player) == null) {
            return "";
        }
        String string = PartyAPI.getPartyLeader((String)PartyAPI.getPartyName((Player)player));
        return string != null ? string : "";
    }

    private String getSkillLevel(McMMOPlayer mcMMOPlayer, String string) {
        switch (string) {
            case "acrobatics": {
                return String.valueOf(mcMMOPlayer.getAcrobaticsManager().getSkillLevel());
            }
            case "alchemy": {
                return String.valueOf(mcMMOPlayer.getAlchemyManager().getSkillLevel());
            }
            case "archery": {
                return String.valueOf(mcMMOPlayer.getArcheryManager().getSkillLevel());
            }
            case "axes": {
                return String.valueOf(mcMMOPlayer.getAxesManager().getSkillLevel());
            }
            case "excavation": {
                return String.valueOf(mcMMOPlayer.getExcavationManager().getSkillLevel());
            }
            case "fishing": {
                return String.valueOf(mcMMOPlayer.getFishingManager().getSkillLevel());
            }
            case "herbalism": {
                return String.valueOf(mcMMOPlayer.getHerbalismManager().getSkillLevel());
            }
            case "mining": {
                return String.valueOf(mcMMOPlayer.getMiningManager().getSkillLevel());
            }
            case "repair": {
                return String.valueOf(mcMMOPlayer.getRepairManager().getSkillLevel());
            }
            case "salvage": {
                return String.valueOf(mcMMOPlayer.getSalvageManager().getSkillLevel());
            }
            case "smelting": {
                return String.valueOf(mcMMOPlayer.getSmeltingManager().getSkillLevel());
            }
            case "swords": {
                return String.valueOf(mcMMOPlayer.getSwordsManager().getSkillLevel());
            }
            case "taming": {
                return String.valueOf(mcMMOPlayer.getTamingManager().getSkillLevel());
            }
            case "unarmed": {
                return String.valueOf(mcMMOPlayer.getUnarmedManager().getSkillLevel());
            }
            case "woodcutting": {
                return String.valueOf(mcMMOPlayer.getWoodcuttingManager().getSkillLevel());
            }
        }
        return null;
    }

    private String getSkillRank(Player player, String string) {
        if (!ExperienceAPI.isValidSkillType((String)string.toUpperCase())) {
            return "";
        }
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return "";
        }
        return String.valueOf(ExperienceAPI.getPlayerRankSkill((UUID)player.getUniqueId(), (String)string.toUpperCase()));
    }

    private String getSkillXP(Player player, String string) {
        if (!ExperienceAPI.isValidSkillType((String)string.toUpperCase())) {
            return "";
        }
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return "";
        }
        return String.valueOf(ExperienceAPI.getXP((Player)player, (String)string.toUpperCase()));
    }

    private String getXPRemaining(Player player, String string) {
        if (!ExperienceAPI.isValidSkillType((String)string.toUpperCase())) {
            return "";
        }
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return "";
        }
        return String.valueOf(ExperienceAPI.getXPRemaining((Player)player, (String)string.toUpperCase()));
    }

    private String getXPToNextLevel(Player player, String string) {
        if (!ExperienceAPI.isValidSkillType((String)string.toUpperCase())) {
            return "";
        }
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return "";
        }
        return String.valueOf(ExperienceAPI.getXPToNextLevel((Player)player, (String)string.toUpperCase()));
    }
}

