/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.iface.RelationParticipator;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.DeluxeRecipientPlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FactionsUUIDHook
implements DeluxeHook {
    DeluxeChat plugin;

    public FactionsUUIDHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @Override
    public void hook() {
        if (Bukkit.getPluginManager().isPluginEnabled("Factions")) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin("Factions");
            String string = plugin.getDescription().getVersion();
            if (string.startsWith("1.6.9.5")) {
                boolean bl;
                boolean bl2 = PlaceholderHandler.registerPlaceholderHook(plugin, new DeluxePlaceholderHook(){

                    @Override
                    public String onPlaceholderRequest(Player player, String string) {
                        switch (string) {
                            case "faction": {
                                return FactionsUUIDHook.this.getFaction(player);
                            }
                            case "power": {
                                return FactionsUUIDHook.this.getFPower(player);
                            }
                            case "powermax": {
                                return FactionsUUIDHook.this.getFPowerMax(player);
                            }
                            case "factionpower": {
                                return FactionsUUIDHook.this.getFacPower(player);
                            }
                            case "factionpowermax": {
                                return FactionsUUIDHook.this.getFacPowerMax(player);
                            }
                            case "title": {
                                return FactionsUUIDHook.this.getFactionTitle(player);
                            }
                            case "role": {
                                return FactionsUUIDHook.this.getFactionRole(player);
                            }
                            case "claims": {
                                return FactionsUUIDHook.this.getFactionClaims(player);
                            }
                            case "onlinemembers": {
                                return FactionsUUIDHook.this.getOnlineFactionMembers(player);
                            }
                            case "allmembers": {
                                return FactionsUUIDHook.this.getFactionMembers(player);
                            }
                            case "chat_tag": {
                                return FactionsUUIDHook.this.getChatTag(player);
                            }
                        }
                        return null;
                    }
                }, true);
                if (bl2) {
                    this.plugin.log.info("Hooked into Factions 1.6.9.5 by drtshock for placeholders!");
                }
                if (DeluxeChat.useRelationPlaceholders() && (bl = PlaceholderHandler.registerRecipientPlaceholderHook(plugin, new DeluxeRecipientPlaceholderHook(){

                    @Override
                    public String onRecipientPlaceholderRequest(Player player, Player player2, String string) {
                        if (player.getName().equals(player2.getName())) {
                            return "";
                        }
                        switch (string) {
                            case "relation": {
                                return FactionsUUIDHook.this.getRelation(player, player2);
                            }
                            case "relation_color": {
                                return FactionsUUIDHook.this.getRelationColor(player, player2);
                            }
                        }
                        return null;
                    }
                }, true))) {
                    this.plugin.log.info("Factions 1.6.9.5 relation placeholders enabled!");
                }
            } else {
                this.plugin.log.info("Could not hook into Factions 1.6.9.5 by drtshock!");
            }
        }
    }

    private String getRelationColor(Player player, Player player2) {
        FPlayer fPlayer = FPlayers.getInstance().getByPlayer(player);
        FPlayer fPlayer2 = FPlayers.getInstance().getByPlayer(player2);
        if (fPlayer == null || fPlayer2 == null) {
            return "";
        }
        ChatColor chatColor = fPlayer.getColorTo((RelationParticipator)fPlayer2);
        if (chatColor == null) {
            return "";
        }
        return chatColor.toString();
    }

    private String getRelation(Player player, Player player2) {
        FPlayer fPlayer = FPlayers.getInstance().getByPlayer(player);
        FPlayer fPlayer2 = FPlayers.getInstance().getByPlayer(player2);
        if (fPlayer == null || fPlayer2 == null) {
            return "";
        }
        String string = fPlayer.getRelationTo((RelationParticipator)fPlayer2).nicename;
        if (string == null) {
            return "";
        }
        return string;
    }

    private boolean hasFaction(Player player) {
        if (FPlayers.getInstance().getByPlayer(player) == null) {
            return false;
        }
        return FPlayers.getInstance().getByPlayer(player).hasFaction();
    }

    private String getFaction(Player player) {
        if (!this.hasFaction(player)) {
            return "";
        }
        return String.valueOf(FPlayers.getInstance().getByPlayer(player).getFaction().getTag());
    }

    private String getFactionTitle(Player player) {
        if (!this.hasFaction(player)) {
            return "";
        }
        return String.valueOf(FPlayers.getInstance().getByPlayer(player).getTitle());
    }

    private String getFactionRole(Player player) {
        if (!this.hasFaction(player)) {
            return "";
        }
        return String.valueOf(FPlayers.getInstance().getByPlayer(player).getRole().getPrefix());
    }

    private String getFactionClaims(Player player) {
        if (!this.hasFaction(player)) {
            return "0";
        }
        return String.valueOf(FPlayers.getInstance().getByPlayer(player).getFaction().getLandRounded());
    }

    private String getFactionMembers(Player player) {
        if (!this.hasFaction(player)) {
            return "0";
        }
        return String.valueOf(FPlayers.getInstance().getByPlayer(player).getFaction().getFPlayers().size());
    }

    private String getOnlineFactionMembers(Player player) {
        if (!this.hasFaction(player)) {
            return "0";
        }
        return String.valueOf(FPlayers.getInstance().getByPlayer(player).getFaction().getOnlinePlayers().size());
    }

    private String getFPower(Player player) {
        FPlayer fPlayer = FPlayers.getInstance().getByPlayer(player);
        if (fPlayer == null) {
            return "0";
        }
        return String.valueOf(fPlayer.getPowerRounded());
    }

    private String getFPowerMax(Player player) {
        FPlayer fPlayer = FPlayers.getInstance().getByPlayer(player);
        if (fPlayer == null) {
            return "0";
        }
        return String.valueOf(fPlayer.getPowerMaxRounded());
    }

    private String getFacPower(Player player) {
        if (!this.hasFaction(player)) {
            return "0";
        }
        return String.valueOf(FPlayers.getInstance().getByPlayer(player).getFaction().getPowerRounded());
    }

    private String getFacPowerMax(Player player) {
        if (!this.hasFaction(player)) {
            return "0";
        }
        return String.valueOf(FPlayers.getInstance().getByPlayer(player).getFaction().getPowerMaxRounded());
    }

    private String getChatTag(Player player) {
        FPlayer fPlayer = FPlayers.getInstance().getByPlayer(player);
        if (fPlayer == null) {
            return "";
        }
        return String.valueOf(fPlayer.getChatTag());
    }
}

