/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import com.massivecraft.factions.RelationParticipator;
import com.massivecraft.factions.entity.MPlayer;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.DeluxeRecipientPlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FactionsHook
implements DeluxeHook {
    DeluxeChat plugin;

    public FactionsHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    private boolean isCompatible(String string) {
        String string2 = string.replace(".", "");
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return false;
        }
        return n >= 275;
    }

    @Override
    public void hook() {
        if (Bukkit.getPluginManager().isPluginEnabled("Factions")) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin("Factions");
            String string = plugin.getDescription().getVersion();
            if (this.isCompatible(string)) {
                boolean bl;
                boolean bl2 = PlaceholderHandler.registerPlaceholderHook(plugin, new DeluxePlaceholderHook(){

                    @Override
                    public String onPlaceholderRequest(Player player, String string) {
                        switch (string) {
                            case "faction": {
                                return FactionsHook.this.getFaction(player);
                            }
                            case "power": {
                                return FactionsHook.this.getFPower(player);
                            }
                            case "powermax": {
                                return FactionsHook.this.getFPowerMax(player);
                            }
                            case "factionpower": {
                                return FactionsHook.this.getFacPower(player);
                            }
                            case "factionpowermax": {
                                return FactionsHook.this.getFacPowerMax(player);
                            }
                            case "title": {
                                return FactionsHook.this.getFactionTitle(player);
                            }
                            case "role": {
                                return FactionsHook.this.getFactionRole(player);
                            }
                            case "claims": {
                                return FactionsHook.this.getFactionClaims(player);
                            }
                            case "onlinemembers": {
                                return FactionsHook.this.getOnlineFactionMembers(player);
                            }
                            case "allmembers": {
                                return FactionsHook.this.getFactionMembers(player);
                            }
                        }
                        return null;
                    }
                }, true);
                if (bl2) {
                    this.plugin.log.info("Hooked into Factions " + string + " for placeholders!");
                }
                if (DeluxeChat.useRelationPlaceholders() && (bl = PlaceholderHandler.registerRecipientPlaceholderHook(plugin, new DeluxeRecipientPlaceholderHook(){

                    @Override
                    public String onRecipientPlaceholderRequest(Player player, Player player2, String string) {
                        if (player.getName().equals(player2.getName())) {
                            return "";
                        }
                        switch (string) {
                            case "relation": {
                                return FactionsHook.this.getRelation(player, player2);
                            }
                            case "relation_color": {
                                return FactionsHook.this.getRelationColor(player, player2);
                            }
                        }
                        return "";
                    }
                }, true))) {
                    this.plugin.log.info("Factions " + string + " relation placeholders enabled!");
                }
            } else {
                this.plugin.log.info("This version of DeluxeChat is only compatible with Factions version 2.7.4 or higher!");
            }
        }
    }

    private String getRelationColor(Player player, Player player2) {
        MPlayer mPlayer = MPlayer.get((Object)player);
        MPlayer mPlayer2 = MPlayer.get((Object)player2);
        if (mPlayer == null || mPlayer2 == null) {
            return "";
        }
        ChatColor chatColor = mPlayer.getColorTo((RelationParticipator)mPlayer2);
        if (chatColor == null) {
            return "";
        }
        return chatColor.toString();
    }

    private String getRelation(Player player, Player player2) {
        MPlayer mPlayer = MPlayer.get((Object)player);
        MPlayer mPlayer2 = MPlayer.get((Object)player2);
        if (mPlayer == null || mPlayer2 == null) {
            return "";
        }
        String string = mPlayer.getRelationTo((RelationParticipator)mPlayer2).toString();
        if (string == null) {
            return "";
        }
        return string;
    }

    private boolean hasFaction(Player player) {
        if (MPlayer.get((Object)player) == null) {
            return false;
        }
        return MPlayer.get((Object)player).hasFaction();
    }

    private String getFaction(Player player) {
        if (!this.hasFaction(player)) {
            return "";
        }
        return String.valueOf(MPlayer.get((Object)player).getFactionName());
    }

    private String getFactionTitle(Player player) {
        if (!this.hasFaction(player)) {
            return "";
        }
        return String.valueOf(MPlayer.get((Object)player).getTitle());
    }

    private String getFactionRole(Player player) {
        if (!this.hasFaction(player)) {
            return "";
        }
        return String.valueOf(MPlayer.get((Object)player).getRole().getPrefix());
    }

    private String getFactionClaims(Player player) {
        if (!this.hasFaction(player)) {
            return "0";
        }
        return String.valueOf(MPlayer.get((Object)player).getFaction().getLandCount());
    }

    private String getFactionMembers(Player player) {
        if (!this.hasFaction(player)) {
            return "0";
        }
        return String.valueOf(MPlayer.get((Object)player).getFaction().getMPlayers().size());
    }

    private String getOnlineFactionMembers(Player player) {
        if (!this.hasFaction(player)) {
            return "0";
        }
        return String.valueOf(MPlayer.get((Object)player).getFaction().getOnlinePlayers().size());
    }

    private String getFPower(Player player) {
        MPlayer mPlayer = MPlayer.get((Object)player);
        if (mPlayer == null) {
            return "0";
        }
        return String.valueOf(mPlayer.getPowerRounded());
    }

    private String getFPowerMax(Player player) {
        MPlayer mPlayer = MPlayer.get((Object)player);
        if (mPlayer == null) {
            return "0";
        }
        return String.valueOf(mPlayer.getPowerMaxRounded());
    }

    private String getFacPower(Player player) {
        if (!this.hasFaction(player)) {
            return "0";
        }
        return String.valueOf(MPlayer.get((Object)player).getFaction().getPowerRounded());
    }

    private String getFacPowerMax(Player player) {
        if (!this.hasFaction(player)) {
            return "0";
        }
        return String.valueOf(MPlayer.get((Object)player).getFaction().getPowerMaxRounded());
    }
}

