/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import me.clip.autosell.AutoSell;
import me.clip.autosell.SellHandler;
import me.clip.autosell.multipliers.Multipliers;
import me.clip.autosell.objects.Multiplier;
import me.clip.autosell.objects.PermissionMultiplier;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AutoSellHook
implements DeluxeHook {
    private DeluxeChat plugin;

    public AutoSellHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @Override
    public void hook() {
        boolean bl;
        AutoSell autoSell;
        if (Bukkit.getPluginManager().isPluginEnabled("AutoSell") && (autoSell = AutoSell.getInstance()) != null && (bl = PlaceholderHandler.registerPlaceholderHook((Plugin)autoSell, new DeluxePlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player player, String string) {
                switch (string) {
                    case "in_autosell_mode": {
                        return AutoSellHook.this.inSell(player);
                    }
                    case "in_autoblocks_mode": {
                        return AutoSellHook.this.inBlocks(player);
                    }
                    case "in_automelt_mode": {
                        return AutoSellHook.this.inSmelt(player);
                    }
                    case "current_shop": {
                        return AutoSellHook.this.getCurrentShop(player);
                    }
                    case "total_multiplier": {
                        return AutoSellHook.this.getTotalMulti(player);
                    }
                    case "time_multiplier_minsleft": {
                        return AutoSellHook.this.getTimeMultiMins(player);
                    }
                    case "time_multiplier_timeleft": {
                        return AutoSellHook.this.getTimeMultiTime(player);
                    }
                    case "time_multiplier": {
                        return AutoSellHook.this.getTimeMulti(player);
                    }
                    case "perm_multiplier_name": {
                        return AutoSellHook.this.getPermMultiName(player);
                    }
                    case "perm_multiplier": {
                        return AutoSellHook.this.getPermMulti(player);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into AutoSell for placeholders!");
        }
    }

    private String getPermMulti(Player player) {
        PermissionMultiplier permissionMultiplier = Multipliers.getPermissionMultiplier((Player)player);
        if (permissionMultiplier == null) {
            return "0.0";
        }
        return String.valueOf(permissionMultiplier.getMultiplier());
    }

    private String getPermMultiName(Player player) {
        PermissionMultiplier permissionMultiplier = Multipliers.getPermissionMultiplier((Player)player);
        if (permissionMultiplier == null) {
            return "";
        }
        return String.valueOf(permissionMultiplier.getIdentifier());
    }

    private String getTimeMulti(Player player) {
        Multiplier multiplier = Multipliers.getMultiplier((String)player.getName());
        if (multiplier == null) {
            return "0";
        }
        return String.valueOf(multiplier.getMultiplier());
    }

    private String getTimeMultiTime(Player player) {
        Multiplier multiplier = Multipliers.getMultiplier((String)player.getName());
        if (multiplier == null) {
            return "0";
        }
        return String.valueOf(multiplier.getTimeLeft());
    }

    private String getTimeMultiMins(Player player) {
        Multiplier multiplier = Multipliers.getMultiplier((String)player.getName());
        if (multiplier == null) {
            return "0";
        }
        return String.valueOf(multiplier.getMinutesLeft());
    }

    private String getTotalMulti(Player player) {
        double d = 0.0;
        if (Multipliers.getGlobalMultiplier() != null) {
            d = Multipliers.getGlobalMultiplier().getMultiplier();
        }
        if (Multipliers.getPermissionMultiplier((Player)player) != null) {
            d += Multipliers.getPermissionMultiplier((Player)player).getMultiplier();
        }
        if (Multipliers.getMultiplier((String)player.getName()) != null) {
            d += Multipliers.getMultiplier((String)player.getName()).getMultiplier();
        }
        return String.valueOf(d);
    }

    private String getCurrentShop(Player player) {
        if (SellHandler.getShop((Player)player) != null) {
            return SellHandler.getShop((Player)player).getName();
        }
        if (SellHandler.getPermShop((Player)player) != null) {
            return SellHandler.getPermShop((Player)player).getName();
        }
        return "";
    }

    private String inSmelt(Player player) {
        if (AutoSell.inSmeltMode((Player)player)) {
            return "&aOn";
        }
        return "&cOff";
    }

    private String inSell(Player player) {
        if (AutoSell.inSellMode((Player)player)) {
            return "&aOn";
        }
        return "&cOff";
    }

    private String inBlocks(Player player) {
        if (AutoSell.inAutoBlockMode((Player)player)) {
            return "&aOn";
        }
        return "&cOff";
    }
}

