/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.fanciful;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import me.clip.deluxechat.fanciful.FancyMessage;
import me.clip.deluxechat.fanciful.JsonRepresentedObject;
import me.clip.deluxechat.fanciful.JsonString;
import me.clip.deluxechat.fanciful.TextualComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

final class MessagePart
implements JsonRepresentedObject,
ConfigurationSerializable,
Cloneable {
    ChatColor color = ChatColor.WHITE;
    ArrayList<ChatColor> styles = new ArrayList();
    String clickActionName = null;
    String clickActionData = null;
    String hoverActionName = null;
    JsonRepresentedObject hoverActionData = null;
    TextualComponent text = null;
    static final BiMap<ChatColor, String> stylesToNames;

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        ChatColor[] chatColorArray = ChatColor.values();
        int n = chatColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChatColor chatColor = chatColorArray[n2];
            if (chatColor.isFormat()) {
                String string;
                switch (chatColor) {
                    case MAGIC: {
                        string = "obfuscated";
                        break;
                    }
                    case UNDERLINE: {
                        string = "underlined";
                        break;
                    }
                    default: {
                        string = chatColor.name().toLowerCase();
                    }
                }
                builder.put((Object)chatColor, (Object)string);
            }
            ++n2;
        }
        stylesToNames = builder.build();
        ConfigurationSerialization.registerClass(MessagePart.class);
    }

    MessagePart(TextualComponent textualComponent) {
        this.text = textualComponent;
    }

    MessagePart() {
        this.text = null;
    }

    boolean hasText() {
        return this.text != null;
    }

    public MessagePart clone() {
        MessagePart messagePart = (MessagePart)super.clone();
        messagePart.styles = (ArrayList)this.styles.clone();
        if (this.hoverActionData instanceof JsonString) {
            messagePart.hoverActionData = new JsonString(((JsonString)this.hoverActionData).getValue());
        } else if (this.hoverActionData instanceof FancyMessage) {
            messagePart.hoverActionData = ((FancyMessage)this.hoverActionData).clone();
        }
        return messagePart;
    }

    @Override
    public void writeJson(JsonWriter jsonWriter) {
        try {
            jsonWriter.beginObject();
            this.text.writeJson(jsonWriter);
            jsonWriter.name("color").value(this.color.name().toLowerCase());
            for (ChatColor chatColor : this.styles) {
                jsonWriter.name((String)stylesToNames.get((Object)chatColor)).value(true);
            }
            if (this.clickActionName != null && this.clickActionData != null) {
                jsonWriter.name("clickEvent").beginObject().name("action").value(this.clickActionName).name("value").value(this.clickActionData).endObject();
            }
            if (this.hoverActionName != null && this.hoverActionData != null) {
                jsonWriter.name("hoverEvent").beginObject().name("action").value(this.hoverActionName).name("value");
                this.hoverActionData.writeJson(jsonWriter);
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (IOException iOException) {
            Bukkit.getLogger().log(Level.WARNING, "A problem occured during writing of JSON string", iOException);
        }
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("text", this.text);
        hashMap.put("styles", this.styles);
        hashMap.put("color", Character.valueOf(this.color.getChar()));
        hashMap.put("hoverActionName", this.hoverActionName);
        hashMap.put("hoverActionData", this.hoverActionData);
        hashMap.put("clickActionName", this.clickActionName);
        hashMap.put("clickActionData", this.clickActionData);
        return hashMap;
    }

    public static MessagePart deserialize(Map<String, Object> map) {
        MessagePart messagePart = new MessagePart((TextualComponent)map.get("text"));
        messagePart.styles = (ArrayList)map.get("styles");
        messagePart.color = ChatColor.getByChar((String)map.get("color").toString());
        messagePart.hoverActionName = map.get("hoverActionName").toString();
        messagePart.hoverActionData = (JsonRepresentedObject)map.get("hoverActionData");
        messagePart.clickActionName = map.get("clickActionName").toString();
        messagePart.clickActionData = map.get("clickActionData").toString();
        return messagePart;
    }
}

