/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.fanciful;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.clip.deluxechat.fanciful.ArrayWrapper;
import me.clip.deluxechat.fanciful.JsonRepresentedObject;
import me.clip.deluxechat.fanciful.JsonString;
import me.clip.deluxechat.fanciful.MessagePart;
import me.clip.deluxechat.fanciful.Reflection;
import me.clip.deluxechat.fanciful.TextualComponent;
import org.bukkit.Achievement;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class FancyMessage
implements JsonRepresentedObject,
Cloneable,
Iterable<MessagePart>,
ConfigurationSerializable {
    private List<MessagePart> messageParts = new ArrayList<MessagePart>();
    private String jsonString;
    private boolean dirty;
    private String lastColor;
    private String chatColor;
    private static JsonParser _stringParser;

    static {
        ConfigurationSerialization.registerClass(FancyMessage.class);
        _stringParser = new JsonParser();
    }

    public FancyMessage clone() {
        FancyMessage fancyMessage = (FancyMessage)super.clone();
        fancyMessage.messageParts = new ArrayList<MessagePart>(this.messageParts.size());
        int n = 0;
        while (n < this.messageParts.size()) {
            fancyMessage.messageParts.add(n, this.messageParts.get(n).clone());
            ++n;
        }
        fancyMessage.dirty = false;
        fancyMessage.jsonString = null;
        return fancyMessage;
    }

    public FancyMessage(String string) {
        this(TextualComponent.rawText(string));
    }

    public FancyMessage(TextualComponent textualComponent) {
        this.messageParts.add(new MessagePart(textualComponent));
        this.jsonString = null;
        this.dirty = false;
        this.lastColor = "";
    }

    public String getLastColor() {
        if (this.lastColor == null) {
            return "";
        }
        return this.lastColor;
    }

    public void setLastColor(String string) {
        if (string != null) {
            this.lastColor = string;
        }
    }

    public FancyMessage() {
        this((TextualComponent)null);
    }

    public FancyMessage text(String string) {
        MessagePart messagePart = this.latest();
        if (messagePart.hasText()) {
            throw new IllegalStateException("text for this message part is already set");
        }
        messagePart.text = TextualComponent.rawText(string);
        this.dirty = true;
        return this;
    }

    public FancyMessage text(TextualComponent textualComponent) {
        MessagePart messagePart = this.latest();
        if (messagePart.hasText()) {
            throw new IllegalStateException("text for this message part is already set");
        }
        messagePart.text = textualComponent;
        this.dirty = true;
        return this;
    }

    public FancyMessage color(ChatColor chatColor) {
        if (!chatColor.isColor()) {
            throw new IllegalArgumentException(String.valueOf(chatColor.name()) + " is not a color");
        }
        this.latest().color = chatColor;
        this.dirty = true;
        return this;
    }

    public FancyMessage style(ChatColor ... chatColorArray) {
        ChatColor[] chatColorArray2 = chatColorArray;
        int n = chatColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChatColor chatColor = chatColorArray2[n2];
            if (!chatColor.isFormat()) {
                throw new IllegalArgumentException(String.valueOf(chatColor.name()) + " is not a style");
            }
            ++n2;
        }
        this.latest().styles.addAll(Arrays.asList(chatColorArray));
        this.dirty = true;
        return this;
    }

    public FancyMessage file(String string) {
        this.onClick("open_file", string);
        return this;
    }

    public FancyMessage link(String string) {
        this.onClick("open_url", string);
        return this;
    }

    public FancyMessage suggest(String string) {
        this.onClick("suggest_command", string);
        return this;
    }

    public FancyMessage command(String string) {
        this.onClick("run_command", string);
        return this;
    }

    public FancyMessage achievementTooltip(String string) {
        this.onHover("show_achievement", new JsonString("achievement." + string));
        return this;
    }

    public FancyMessage achievementTooltip(Achievement achievement) {
        try {
            Object object = Reflection.getMethod(Reflection.getOBCClass("CraftStatistic"), "getNMSAchievement", Achievement.class).invoke(null, achievement);
            return this.achievementTooltip((String)Reflection.getField(Reflection.getNMSClass("Achievement"), "name").get(object));
        }
        catch (IllegalAccessException illegalAccessException) {
            Bukkit.getLogger().log(Level.WARNING, "Could not access method.", illegalAccessException);
            return this;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Bukkit.getLogger().log(Level.WARNING, "Argument could not be passed.", illegalArgumentException);
            return this;
        }
        catch (InvocationTargetException invocationTargetException) {
            Bukkit.getLogger().log(Level.WARNING, "A error has occured durring invoking of method.", invocationTargetException);
            return this;
        }
    }

    public FancyMessage statisticTooltip(Statistic statistic) {
        Statistic.Type type = statistic.getType();
        if (type != Statistic.Type.UNTYPED) {
            throw new IllegalArgumentException("That statistic requires an additional " + type + " parameter!");
        }
        try {
            Object object = Reflection.getMethod(Reflection.getOBCClass("CraftStatistic"), "getNMSStatistic", Statistic.class).invoke(null, statistic);
            return this.achievementTooltip((String)Reflection.getField(Reflection.getNMSClass("Statistic"), "name").get(object));
        }
        catch (IllegalAccessException illegalAccessException) {
            Bukkit.getLogger().log(Level.WARNING, "Could not access method.", illegalAccessException);
            return this;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Bukkit.getLogger().log(Level.WARNING, "Argument could not be passed.", illegalArgumentException);
            return this;
        }
        catch (InvocationTargetException invocationTargetException) {
            Bukkit.getLogger().log(Level.WARNING, "A error has occured durring invoking of method.", invocationTargetException);
            return this;
        }
    }

    public FancyMessage statisticTooltip(Statistic statistic, Material material) {
        Statistic.Type type = statistic.getType();
        if (type == Statistic.Type.UNTYPED) {
            throw new IllegalArgumentException("That statistic needs no additional parameter!");
        }
        if (type == Statistic.Type.BLOCK && material.isBlock() || type == Statistic.Type.ENTITY) {
            throw new IllegalArgumentException("Wrong parameter type for that statistic - needs " + type + "!");
        }
        try {
            Object object = Reflection.getMethod(Reflection.getOBCClass("CraftStatistic"), "getMaterialStatistic", Statistic.class, Material.class).invoke(null, statistic, material);
            return this.achievementTooltip((String)Reflection.getField(Reflection.getNMSClass("Statistic"), "name").get(object));
        }
        catch (IllegalAccessException illegalAccessException) {
            Bukkit.getLogger().log(Level.WARNING, "Could not access method.", illegalAccessException);
            return this;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Bukkit.getLogger().log(Level.WARNING, "Argument could not be passed.", illegalArgumentException);
            return this;
        }
        catch (InvocationTargetException invocationTargetException) {
            Bukkit.getLogger().log(Level.WARNING, "A error has occured durring invoking of method.", invocationTargetException);
            return this;
        }
    }

    public FancyMessage statisticTooltip(Statistic statistic, EntityType entityType) {
        Statistic.Type type = statistic.getType();
        if (type == Statistic.Type.UNTYPED) {
            throw new IllegalArgumentException("That statistic needs no additional parameter!");
        }
        if (type != Statistic.Type.ENTITY) {
            throw new IllegalArgumentException("Wrong parameter type for that statistic - needs " + type + "!");
        }
        try {
            Object object = Reflection.getMethod(Reflection.getOBCClass("CraftStatistic"), "getEntityStatistic", Statistic.class, EntityType.class).invoke(null, statistic, entityType);
            return this.achievementTooltip((String)Reflection.getField(Reflection.getNMSClass("Statistic"), "name").get(object));
        }
        catch (IllegalAccessException illegalAccessException) {
            Bukkit.getLogger().log(Level.WARNING, "Could not access method.", illegalAccessException);
            return this;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Bukkit.getLogger().log(Level.WARNING, "Argument could not be passed.", illegalArgumentException);
            return this;
        }
        catch (InvocationTargetException invocationTargetException) {
            Bukkit.getLogger().log(Level.WARNING, "A error has occured durring invoking of method.", invocationTargetException);
            return this;
        }
    }

    public FancyMessage itemTooltip(String string) {
        this.onHover("show_item", new JsonString(string));
        return this;
    }

    public FancyMessage itemTooltip(ItemStack itemStack) {
        try {
            Object object = Reflection.getMethod(Reflection.getOBCClass("inventory.CraftItemStack"), "asNMSCopy", ItemStack.class).invoke(null, itemStack);
            return this.itemTooltip(Reflection.getMethod(Reflection.getNMSClass("ItemStack"), "save", Reflection.getNMSClass("NBTTagCompound")).invoke(object, Reflection.getNMSClass("NBTTagCompound").newInstance()).toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this;
        }
    }

    public FancyMessage tooltip(String string) {
        this.onHover("show_text", new JsonString(string));
        return this;
    }

    public FancyMessage tooltip(Iterable<String> iterable) {
        this.tooltip(ArrayWrapper.toArray(iterable, String.class));
        return this;
    }

    public FancyMessage tooltip(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < stringArray.length) {
            stringBuilder.append(stringArray[n]);
            if (n != stringArray.length - 1) {
                stringBuilder.append('\n');
            }
            ++n;
        }
        this.tooltip(stringBuilder.toString());
        return this;
    }

    public FancyMessage formattedTooltip(FancyMessage fancyMessage) {
        for (MessagePart messagePart : fancyMessage.messageParts) {
            if (messagePart.clickActionData != null && messagePart.clickActionName != null) {
                throw new IllegalArgumentException("The tooltip text cannot have click data.");
            }
            if (messagePart.hoverActionData == null || messagePart.hoverActionName == null) continue;
            throw new IllegalArgumentException("The tooltip text cannot have a tooltip.");
        }
        this.onHover("show_text", fancyMessage);
        return this;
    }

    public FancyMessage formattedTooltip(FancyMessage ... fancyMessageArray) {
        if (fancyMessageArray.length < 1) {
            this.onHover(null, null);
            return this;
        }
        FancyMessage fancyMessage = new FancyMessage();
        fancyMessage.messageParts.clear();
        int n = 0;
        while (n < fancyMessageArray.length) {
            try {
                for (MessagePart messagePart : fancyMessageArray[n]) {
                    if (messagePart.clickActionData != null && messagePart.clickActionName != null) {
                        throw new IllegalArgumentException("The tooltip text cannot have click data.");
                    }
                    if (messagePart.hoverActionData != null && messagePart.hoverActionName != null) {
                        throw new IllegalArgumentException("The tooltip text cannot have a tooltip.");
                    }
                    if (!messagePart.hasText()) continue;
                    fancyMessage.messageParts.add(messagePart.clone());
                }
                if (n != fancyMessageArray.length - 1) {
                    fancyMessage.messageParts.add(new MessagePart(TextualComponent.rawText("\n")));
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Bukkit.getLogger().log(Level.WARNING, "Failed to clone object", cloneNotSupportedException);
                return this;
            }
            ++n;
        }
        return this.formattedTooltip(fancyMessage.messageParts.isEmpty() ? null : fancyMessage);
    }

    public FancyMessage formattedTooltip(Iterable<FancyMessage> iterable) {
        return this.formattedTooltip(ArrayWrapper.toArray(iterable, FancyMessage.class));
    }

    public FancyMessage then(String string) {
        return this.then(TextualComponent.rawText(string));
    }

    public FancyMessage then(TextualComponent textualComponent) {
        if (!this.latest().hasText()) {
            throw new IllegalStateException("previous message part has no text");
        }
        this.messageParts.add(new MessagePart(textualComponent));
        this.dirty = true;
        return this;
    }

    public FancyMessage then() {
        if (!this.latest().hasText()) {
            throw new IllegalStateException("previous message part has no text");
        }
        this.messageParts.add(new MessagePart());
        this.dirty = true;
        return this;
    }

    @Override
    public void writeJson(JsonWriter jsonWriter) {
        if (this.messageParts.size() == 1) {
            this.latest().writeJson(jsonWriter);
        } else {
            jsonWriter.beginObject().name("text").value("").name("extra").beginArray();
            for (MessagePart messagePart : this) {
                messagePart.writeJson(jsonWriter);
            }
            jsonWriter.endArray().endObject();
        }
    }

    public String toJSONString() {
        if (!this.dirty && this.jsonString != null) {
            return this.jsonString;
        }
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            this.writeJson(jsonWriter);
            jsonWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("invalid message");
        }
        this.jsonString = stringWriter.toString();
        this.dirty = false;
        return this.jsonString;
    }

    public String toOldMessageFormat() {
        StringBuilder stringBuilder = new StringBuilder();
        for (MessagePart messagePart : this) {
            stringBuilder.append((Object)(messagePart.color == null ? "" : messagePart.color));
            for (ChatColor chatColor : messagePart.styles) {
                stringBuilder.append(chatColor);
            }
            stringBuilder.append(messagePart.text);
        }
        return stringBuilder.toString();
    }

    private MessagePart latest() {
        return this.messageParts.get(this.messageParts.size() - 1);
    }

    private void onClick(String string, String string2) {
        MessagePart messagePart = this.latest();
        messagePart.clickActionName = string;
        messagePart.clickActionData = string2;
        this.dirty = true;
    }

    private void onHover(String string, JsonRepresentedObject jsonRepresentedObject) {
        MessagePart messagePart = this.latest();
        messagePart.hoverActionName = string;
        messagePart.hoverActionData = jsonRepresentedObject;
        this.dirty = true;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("messageParts", this.messageParts);
        return hashMap;
    }

    public static FancyMessage deserialize(Map<String, Object> map) {
        FancyMessage fancyMessage = new FancyMessage();
        fancyMessage.messageParts = (List)map.get("messageParts");
        fancyMessage.jsonString = map.containsKey("JSON") ? map.get("JSON").toString() : null;
        fancyMessage.dirty = !map.containsKey("JSON");
        return fancyMessage;
    }

    @Override
    public Iterator<MessagePart> iterator() {
        return this.messageParts.iterator();
    }

    public static FancyMessage deserialize(String string) {
        JsonObject jsonObject = _stringParser.parse(string).getAsJsonObject();
        JsonArray jsonArray = jsonObject.getAsJsonArray("extra");
        FancyMessage fancyMessage = new FancyMessage();
        fancyMessage.messageParts.clear();
        for (JsonElement jsonElement : jsonArray) {
            MessagePart messagePart = new MessagePart();
            JsonObject jsonObject2 = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject2.entrySet()) {
                JsonObject jsonObject3;
                if (TextualComponent.isTextKey((String)entry.getKey())) {
                    jsonObject3 = new HashMap();
                    jsonObject3.put("key", entry.getKey());
                    if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                        jsonObject3.put("value", ((JsonElement)entry.getValue()).getAsString());
                    } else {
                        for (Map.Entry entry2 : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                            jsonObject3.put("value." + (String)entry2.getKey(), ((JsonElement)entry2.getValue()).getAsString());
                        }
                    }
                    messagePart.text = TextualComponent.deserialize((Map<String, Object>)jsonObject3);
                    continue;
                }
                if (MessagePart.stylesToNames.inverse().containsKey(entry.getKey())) {
                    if (!((JsonElement)entry.getValue()).getAsBoolean()) continue;
                    messagePart.styles.add((ChatColor)MessagePart.stylesToNames.inverse().get(entry.getKey()));
                    continue;
                }
                if (((String)entry.getKey()).equals("color")) {
                    messagePart.color = ChatColor.valueOf((String)((JsonElement)entry.getValue()).getAsString().toUpperCase());
                    continue;
                }
                if (((String)entry.getKey()).equals("clickEvent")) {
                    jsonObject3 = ((JsonElement)entry.getValue()).getAsJsonObject();
                    messagePart.clickActionName = jsonObject3.get("action").getAsString();
                    messagePart.clickActionData = jsonObject3.get("value").getAsString();
                    continue;
                }
                if (!((String)entry.getKey()).equals("hoverEvent")) continue;
                jsonObject3 = ((JsonElement)entry.getValue()).getAsJsonObject();
                messagePart.hoverActionName = jsonObject3.get("action").getAsString();
                messagePart.hoverActionData = jsonObject3.get("value").isJsonPrimitive() ? new JsonString(jsonObject3.get("value").getAsString()) : FancyMessage.deserialize(jsonObject3.get("value").toString());
            }
            fancyMessage.messageParts.add(messagePart);
        }
        return fancyMessage;
    }

    public String getChatColor() {
        if (this.chatColor == null) {
            return "";
        }
        return this.chatColor;
    }

    public void setChatColor(String string) {
        this.chatColor = string;
    }
}

