/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import me.clip.deluxechat.ConfigWrapper;
import me.clip.deluxechat.DeluxeCommands;
import me.clip.deluxechat.DeluxeConfig;
import me.clip.deluxechat.DeluxeUtil;
import me.clip.deluxechat.Lang;
import me.clip.deluxechat.MessageCommand;
import me.clip.deluxechat.ReplyCommand;
import me.clip.deluxechat.SocialSpyCommand;
import me.clip.deluxechat.ToggleCommand;
import me.clip.deluxechat.bungee.BungeeMessageListener;
import me.clip.deluxechat.compatibility.CompatibilityManager;
import me.clip.deluxechat.compatibility.Spigot_1_10_R1_Chat;
import me.clip.deluxechat.compatibility.Spigot_1_11_R1_Chat;
import me.clip.deluxechat.compatibility.Spigot_1_8_R2_Chat;
import me.clip.deluxechat.compatibility.Spigot_1_8_R3_Chat;
import me.clip.deluxechat.compatibility.Spigot_1_9_R1_Chat;
import me.clip.deluxechat.compatibility.Spigot_1_9_R2_Chat;
import me.clip.deluxechat.fanciful.FancyMessage;
import me.clip.deluxechat.hooks.ASkyblockHook;
import me.clip.deluxechat.hooks.AcidIslandHook;
import me.clip.deluxechat.hooks.AutoRankHook;
import me.clip.deluxechat.hooks.AutoSellHook;
import me.clip.deluxechat.hooks.BanManagerHook;
import me.clip.deluxechat.hooks.BungeeChannelHook;
import me.clip.deluxechat.hooks.ChatColorHook;
import me.clip.deluxechat.hooks.ChatReactionHook;
import me.clip.deluxechat.hooks.CheckNameHistoryHook;
import me.clip.deluxechat.hooks.DeluxeTagsHook;
import me.clip.deluxechat.hooks.EZBlocksHook;
import me.clip.deluxechat.hooks.EZPrestigeHook;
import me.clip.deluxechat.hooks.EZRanksLiteHook;
import me.clip.deluxechat.hooks.EZRanksProHook;
import me.clip.deluxechat.hooks.EssentialsHook;
import me.clip.deluxechat.hooks.FactionsHook;
import me.clip.deluxechat.hooks.FactionsUUIDHook;
import me.clip.deluxechat.hooks.GAListenerHook;
import me.clip.deluxechat.hooks.GangsPlusHook;
import me.clip.deluxechat.hooks.HeroesHook;
import me.clip.deluxechat.hooks.IslandWorldHook;
import me.clip.deluxechat.hooks.JobsHook;
import me.clip.deluxechat.hooks.KillRewardsHook;
import me.clip.deluxechat.hooks.KillStatsHook;
import me.clip.deluxechat.hooks.LWCHook;
import me.clip.deluxechat.hooks.MVdWPlaceholderHook;
import me.clip.deluxechat.hooks.MarriageMasterHook;
import me.clip.deluxechat.hooks.McInfectedHook;
import me.clip.deluxechat.hooks.McInfectedRanksHook;
import me.clip.deluxechat.hooks.McMMOHook;
import me.clip.deluxechat.hooks.NickyHook;
import me.clip.deluxechat.hooks.PlaceholderAPIHook;
import me.clip.deluxechat.hooks.PlayerPlaceholders;
import me.clip.deluxechat.hooks.PlayerPointsHook;
import me.clip.deluxechat.hooks.PlotSquaredHook;
import me.clip.deluxechat.hooks.PrisonGangsHook;
import me.clip.deluxechat.hooks.PvPStatsHook;
import me.clip.deluxechat.hooks.QuickSellHook;
import me.clip.deluxechat.hooks.RoyalCommandsHook;
import me.clip.deluxechat.hooks.SQLPermsHook;
import me.clip.deluxechat.hooks.SQLTokensHook;
import me.clip.deluxechat.hooks.SimpleClansHook;
import me.clip.deluxechat.hooks.SimpleCoinsAPIHook;
import me.clip.deluxechat.hooks.SimplePrefixHook;
import me.clip.deluxechat.hooks.SimpleSuffixHook;
import me.clip.deluxechat.hooks.SkyWarsReloadedHook;
import me.clip.deluxechat.hooks.StatisticPlaceholders1_10_R1;
import me.clip.deluxechat.hooks.StatisticPlaceholders1_11_R1;
import me.clip.deluxechat.hooks.StatisticPlaceholders1_8_R2;
import me.clip.deluxechat.hooks.StatisticPlaceholders1_8_R3;
import me.clip.deluxechat.hooks.StatisticPlaceholders1_9_R1;
import me.clip.deluxechat.hooks.StatisticPlaceholders1_9_R2;
import me.clip.deluxechat.hooks.SurvivalGamesHook;
import me.clip.deluxechat.hooks.TokenEnchantHook;
import me.clip.deluxechat.hooks.TownyHook;
import me.clip.deluxechat.hooks.USkyblockHook;
import me.clip.deluxechat.hooks.UltimateVotesHook;
import me.clip.deluxechat.hooks.VanishNoPacketHook;
import me.clip.deluxechat.hooks.VaultHook;
import me.clip.deluxechat.hooks.VotePartyHook;
import me.clip.deluxechat.hooks.WerewolfHook;
import me.clip.deluxechat.hooks.WickedSkywarsHook;
import me.clip.deluxechat.javascript.JavascriptPlaceholder;
import me.clip.deluxechat.javascript.JavascriptPlaceholders;
import me.clip.deluxechat.listeners.AsyncPlayerChatListener;
import me.clip.deluxechat.listeners.PlaceholderEventListener;
import me.clip.deluxechat.listeners.PlayerJoinListener;
import me.clip.deluxechat.listeners.TownyChatListener;
import me.clip.deluxechat.messaging.PrivateMessageType;
import me.clip.deluxechat.objects.DeluxeFormat;
import me.clip.deluxechat.objects.DeluxePrivateMessageFormat;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import me.clip.deluxechat.placeholders.PlaceholderLayout;
import me.clip.deluxechat.updater.SpigotUpdater;
import me.clip.resourcenews.ResourceNewsManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class DeluxeChat
extends JavaPlugin {
    public Logger log = this.getLogger();
    protected static Map<Integer, DeluxeFormat> formats = new TreeMap<Integer, DeluxeFormat>();
    protected static List<String> localPlayers;
    protected static Map<String, String> blacklist;
    protected static boolean useBlacklist;
    protected static boolean opsUseGroupFormat;
    protected static boolean joinGlobal;
    protected static String serverName;
    protected static String booleanTrue;
    protected static String booleanFalse;
    protected static Map<String, String> inPrivateChat;
    protected static List<String> socialSpy;
    protected static DeluxePrivateMessageFormat toSenderPmFormat;
    protected static DeluxePrivateMessageFormat toRecipientPmFormat;
    protected static String socialSpyFormat;
    protected static boolean useRelationPlaceholders;
    protected static SimpleDateFormat timestampFormat;
    protected VaultHook vault;
    private TownyHook towny;
    private TownyChatListener townychat;
    protected PlaceholderHandler placeholders;
    protected DeluxeConfig c = new DeluxeConfig(this);
    protected DeluxeCommands commands = new DeluxeCommands(this);
    private SpigotUpdater updater = null;
    protected ResourceNewsManager newsManager = null;
    private CompatibilityManager chat;
    private static BungeeMessageListener bungee;
    private static boolean bungeePM;
    private static DeluxeChat instance;
    private ConfigWrapper messages = new ConfigWrapper(this, "", "messages.yml");
    private BanManagerHook banManager = null;
    protected VanishNoPacketHook vanishNoPacket = null;
    private static boolean useEssentials;

    static {
        blacklist = new HashMap<String, String>();
        inPrivateChat = new HashMap<String, String>();
        socialSpy = new ArrayList<String>();
    }

    public void onEnable() {
        DeluxeChat.loadConfig0();
        if (this.setupCompatibility()) {
            instance = this;
            this.c.loadConfigFile();
            this.log.info(String.valueOf(this.c.loadFormats()) + " formats loaded!");
            this.messages.createNewFile("Loading DeluxeChat messages.yml", "DeluxeChat language file\nYou can edit all the messages here!\nYou must restart for changes to take affect when editing this file!");
            this.loadMessages();
            useBlacklist = this.c.useBlacklist();
            joinGlobal = true;
            booleanTrue = this.c.booleanTrue();
            booleanFalse = this.c.booleanFalse();
            useRelationPlaceholders = this.c.useRelationPlaceholders();
            socialSpyFormat = this.c.socialSpyFormat();
            this.c.loadPMFormats();
            try {
                timestampFormat = new SimpleDateFormat(this.c.timestampFormat());
            }
            catch (Exception exception) {
                timestampFormat = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
            }
            this.placeholders = new PlaceholderHandler(this);
            if (useRelationPlaceholders) {
                Bukkit.getPluginManager().registerEvents((Listener)new PlaceholderEventListener(this), (Plugin)this);
            }
            if (useBlacklist) {
                this.log.info(String.valueOf(this.c.loadBlacklist()) + " entries added to the chat_filter!");
            }
            this.initializeHooks();
            if (this.towny != null && this.towny.enabled() && this.towny.townyChatEnabled()) {
                this.townychat = new TownyChatListener(this);
                this.townychat.hook();
                Bukkit.getServer().getPluginManager().registerEvents((Listener)this.townychat, (Plugin)this);
                this.log.info("TownyChat integration is enabled!");
            } else {
                Bukkit.getServer().getPluginManager().registerEvents((Listener)new AsyncPlayerChatListener(this), (Plugin)this);
            }
            int n = PlaceholderHandler.getRegisteredPlaceholderPlugins() != null ? PlaceholderHandler.getRegisteredPlaceholderPlugins().size() : 0;
            this.log.info(String.valueOf(n) + " placeholder hooks have been registered and are enabled.");
            if (this.getConfig().getBoolean("hooks.banmanager") && Bukkit.getPluginManager().isPluginEnabled("BanManager")) {
                this.banManager = new BanManagerHook();
            }
            if (this.getConfig().getBoolean("hooks.vanishnopacket")) {
                this.vanishNoPacket = new VanishNoPacketHook();
                this.vanishNoPacket.hook();
                if (!this.vanishNoPacket.isHooked()) {
                    this.vanishNoPacket = null;
                }
            }
            Bukkit.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
            serverName = this.getConfig().getString("bungeecord.servername");
            if (this.getConfig().getBoolean("bungeecord.enabled")) {
                bungeePM = this.c.bungeePMEnabled();
                joinGlobal = this.c.joinGlobal();
                localPlayers = new ArrayList<String>();
                this.log.info("Bungee integration has been enabled!");
                this.log.info("Remember DeluxeChat.jar must be running on your bungee proxy server also for integration to work properly!!");
                bungee = new BungeeMessageListener(this);
                this.getCommand("gtoggle").setExecutor((CommandExecutor)new ToggleCommand(this));
                this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "DeluxeChat");
                this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "DeluxeChat", (PluginMessageListener)bungee);
                this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "DeluxeChatPM");
                this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "DeluxeChatPM", (PluginMessageListener)bungee);
                this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "DeluxeChatSocialSpy");
                this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "DeluxeChatSocialSpy", (PluginMessageListener)bungee);
            } else {
                bungeePM = false;
            }
            this.getCommand("dchat").setExecutor((CommandExecutor)this.commands);
            if (this.getConfig().getBoolean("private_message.enabled")) {
                this.getCommand("msg").setExecutor((CommandExecutor)new MessageCommand(this));
                this.getCommand("reply").setExecutor((CommandExecutor)new ReplyCommand(this));
                this.getCommand("socialspy").setExecutor((CommandExecutor)new SocialSpyCommand(this));
            }
            if (this.getConfig().getBoolean("check_updates")) {
                this.updater = new SpigotUpdater(this);
                this.getUpdater().checkUpdates();
                if (SpigotUpdater.updateAvailable()) {
                    System.out.println("----------------------------");
                    System.out.println("     DeluxeChat Updater");
                    System.out.println(" ");
                    System.out.println("An update for DeluxeChat has been found!");
                    System.out.println("DeluxeChat " + SpigotUpdater.getHighest());
                    System.out.println("You are running " + this.getDescription().getVersion());
                    System.out.println(" ");
                    System.out.println("Download at http://www.spigotmc.org/resources/deluxechat.1277/");
                    System.out.println("----------------------------");
                } else {
                    System.out.println("----------------------------");
                    System.out.println("     DeluxeChat Updater");
                    System.out.println(" ");
                    System.out.println("You are running " + this.getDescription().getVersion());
                    System.out.println("The latest version");
                    System.out.println("of DeluxeChat!");
                    System.out.println(" ");
                    System.out.println("----------------------------");
                }
                this.newsManager = new ResourceNewsManager((Plugin)this);
            }
        } else {
            this.log.warning("DeluxeChat is not compatible with your server version!");
            this.log.warning("DeluxeChat will now disable! Please update to 1.8.3/1.8.4/1.9 to use this version!");
            this.log.warning("If you need DeluxeChat for 1.8.1 or Spigot 1649 / 1.7.10, use DeluxeChat 1.5.9");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        this.placeholders.unregisterAll();
        this.placeholders = null;
        if (this.townychat != null) {
            this.townychat.clear();
        }
        PlaceholderLayout.unloadAll();
        JavascriptPlaceholders.cleanup();
        JavascriptPlaceholder.cleanup();
        toSenderPmFormat = null;
        toRecipientPmFormat = null;
        blacklist = null;
        formats = null;
        localPlayers = null;
        inPrivateChat = null;
        socialSpy = null;
        instance = null;
    }

    private void loadMessages() {
        Lang.setFile(this.messages.getConfig());
        Lang[] langArray = Lang.values();
        int n = langArray.length;
        int n2 = 0;
        while (n2 < n) {
            Lang lang = langArray[n2];
            this.messages.getConfig().addDefault(lang.getPath(), (Object)lang.getDefault());
            ++n2;
        }
        this.messages.getConfig().options().copyDefaults(true);
        this.messages.saveConfig();
    }

    public CompatibilityManager getChat() {
        return this.chat;
    }

    public SpigotUpdater getUpdater() {
        return this.updater;
    }

    public static Map<Integer, DeluxeFormat> getFormats() {
        return formats;
    }

    private boolean setupCompatibility() {
        String string;
        try {
            string = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        if (string.equals("v1_8_R2")) {
            this.chat = new Spigot_1_8_R2_Chat();
        } else if (string.equals("v1_8_R3")) {
            this.chat = new Spigot_1_8_R3_Chat();
        } else if (string.equals("v1_9_R1")) {
            this.chat = new Spigot_1_9_R1_Chat();
        } else if (string.equals("v1_9_R2")) {
            this.chat = new Spigot_1_9_R2_Chat();
        } else if (string.equals("v1_10_R1")) {
            this.chat = new Spigot_1_10_R1_Chat();
        } else if (string.equals("v1_11_R1")) {
            this.chat = new Spigot_1_11_R1_Chat();
        }
        return this.chat != null;
    }

    public void initializeHooks() {
        this.towny = null;
        if (this.getConfig().getBoolean("hooks.javascript_placeholders")) {
            new JavascriptPlaceholders(this).hook();
        }
        if (this.getConfig().getBoolean("bungeecord.enabled")) {
            new BungeeChannelHook(this).hook();
        }
        new PlayerPlaceholders().hook();
        if (this.getConfig().getBoolean("hooks.minecraft_statistics")) {
            String string;
            try {
                string = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string = "v1_8_R1";
            }
            if (string.equals("v1_8_R2")) {
                new StatisticPlaceholders1_8_R2(this).hook();
            } else if (string.equals("v1_8_R3")) {
                new StatisticPlaceholders1_8_R3(this).hook();
            } else if (string.equals("v1_9_R1")) {
                new StatisticPlaceholders1_9_R1(this).hook();
            } else if (string.equals("v1_9_R2")) {
                new StatisticPlaceholders1_9_R2(this).hook();
            } else if (string.equals("v1_10_R1")) {
                new StatisticPlaceholders1_10_R1(this).hook();
            } else if (string.equals("v1_11_R1")) {
                new StatisticPlaceholders1_11_R1(this).hook();
            }
        }
        if (this.getConfig().getBoolean("hooks.acidisland")) {
            new AcidIslandHook(this).hook();
        } else if (this.getConfig().getBoolean("hooks.askyblock")) {
            new ASkyblockHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.autorank")) {
            new AutoRankHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.autosell")) {
            new AutoSellHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.chatcolor")) {
            new ChatColorHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.chatreaction")) {
            new ChatReactionHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.checknamehistory")) {
            new CheckNameHistoryHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.deluxetags")) {
            new DeluxeTagsHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.essentials")) {
            new EssentialsHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.ezblocks")) {
            new EZBlocksHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.ezprestige")) {
            new EZPrestigeHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.ezrankslite")) {
            new EZRanksLiteHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.ezrankspro")) {
            new EZRanksProHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.factions_mcore")) {
            new FactionsHook(this).hook();
        } else if (this.getConfig().getBoolean("hooks.factions_uuid")) {
            new FactionsUUIDHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.galistener")) {
            new GAListenerHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.gangsplus")) {
            new GangsPlusHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.heroes")) {
            new HeroesHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.islandworld")) {
            new IslandWorldHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.jobs")) {
            new JobsHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.killrewards")) {
            new KillRewardsHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.killstats")) {
            new KillStatsHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.lwc")) {
            new LWCHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.marriagemaster")) {
            new MarriageMasterHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.mcinfected")) {
            new McInfectedHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.mcinfected-ranks")) {
            new McInfectedRanksHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.mcmmo")) {
            new McMMOHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.mvdw_placeholderapi")) {
            new MVdWPlaceholderHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.nicky")) {
            new NickyHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.placeholderapi")) {
            new PlaceholderAPIHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.playerpoints")) {
            new PlayerPointsHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.plotsquared")) {
            new PlotSquaredHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.prisongangs")) {
            new PrisonGangsHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.pvpstats")) {
            new PvPStatsHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.quicksell")) {
            new QuickSellHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.royalcommands")) {
            new RoyalCommandsHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.simpleclans")) {
            new SimpleClansHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.simplecoinsapi")) {
            new SimpleCoinsAPIHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.simpleprefix")) {
            new SimplePrefixHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.simple_suffix")) {
            new SimpleSuffixHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.skywarsreloaded")) {
            new SkyWarsReloadedHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.sqlperms")) {
            new SQLPermsHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.sqltokens")) {
            new SQLTokensHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.survivalgames")) {
            new SurvivalGamesHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.tokenenchant")) {
            new TokenEnchantHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.towny")) {
            this.towny = new TownyHook(this);
            this.towny.hook();
        }
        if (this.getConfig().getBoolean("hooks.uskyblock")) {
            new USkyblockHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.ultimatevotes")) {
            new UltimateVotesHook(this).hook();
        }
        this.vault = new VaultHook(this);
        this.vault.hook();
        if (this.vault.useVaultPerms() && this.vault.useVaultChat()) {
            opsUseGroupFormat = this.c.opsUseGroupFormat();
        }
        if (this.getConfig().getBoolean("hooks.voteparty")) {
            new VotePartyHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.werewolf")) {
            new WerewolfHook(this).hook();
        }
        if (this.getConfig().getBoolean("hooks.wickedskywars")) {
            new WickedSkywarsHook(this).hook();
        }
    }

    public DeluxeFormat getTestFormat(String string) {
        for (DeluxeFormat deluxeFormat : DeluxeChat.getFormats().values()) {
            if (!deluxeFormat.getIdentifier().equalsIgnoreCase(string)) continue;
            return DeluxeFormat.newInstance(deluxeFormat);
        }
        return null;
    }

    public DeluxeFormat getPlayerFormat(Player player) {
        DeluxeFormat deluxeFormat = null;
        if (player.isOp() && opsUseGroupFormat && this.vault != null && this.vault.useVaultPerms()) {
            for (DeluxeFormat deluxeFormat2 : DeluxeChat.getFormats().values()) {
                if (!this.vault.opHasPermission(player, "chatformat." + deluxeFormat2.getIdentifier())) continue;
                deluxeFormat = deluxeFormat2;
                break;
            }
        } else {
            for (DeluxeFormat deluxeFormat3 : DeluxeChat.getFormats().values()) {
                if (!player.hasPermission("chatformat." + deluxeFormat3.getIdentifier())) continue;
                deluxeFormat = deluxeFormat3;
                break;
            }
        }
        if (deluxeFormat == null) {
            deluxeFormat = new DeluxeFormat("default", Integer.MAX_VALUE);
            deluxeFormat.setChannel("");
            deluxeFormat.setPrefix("");
            deluxeFormat.setNameColor("");
            deluxeFormat.setName("%player%");
            deluxeFormat.setSuffix(" &8> &r");
            deluxeFormat.setChatColor("");
            deluxeFormat.setShowChannelTooltip(false);
            deluxeFormat.setChannelTooltip(null);
            deluxeFormat.setShowPreTooltip(false);
            deluxeFormat.setPrefixTooltip(null);
            deluxeFormat.setShowNameTooltip(false);
            deluxeFormat.setNameTooltip(null);
            deluxeFormat.setShowSuffixTooltip(false);
            deluxeFormat.setSuffixTooltip(null);
            deluxeFormat.setUsePreClick(false);
            deluxeFormat.setPreClickCmd(null);
            deluxeFormat.setUseNameClick(true);
            deluxeFormat.setNameClickCmd("/msg %player% ");
            deluxeFormat.setUseSuffixClick(false);
            deluxeFormat.setSuffixClickCmd(null);
        }
        return deluxeFormat;
    }

    public boolean isMuted(Player player) {
        boolean bl = false;
        if (this.banManager != null) {
            bl = this.banManager.isMuted(player);
        }
        if (!bl && useEssentials) {
            bl = EssentialsHook.isMuted(player);
        }
        return bl;
    }

    public FancyMessage getBungeePrivateMessageFormat(Player player, DeluxePrivateMessageFormat deluxePrivateMessageFormat) {
        if (deluxePrivateMessageFormat == null) {
            return null;
        }
        String string = deluxePrivateMessageFormat.getFormat();
        string = PlaceholderHandler.setPlaceholders(player, string);
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        FancyMessage fancyMessage = new FancyMessage(string);
        String string2 = DeluxeUtil.getLastColor(string);
        fancyMessage.setLastColor(string2);
        fancyMessage.setChatColor(ChatColor.translateAlternateColorCodes((char)'&', (String)deluxePrivateMessageFormat.getChatColor()));
        if (deluxePrivateMessageFormat.getTooltip() != null && !deluxePrivateMessageFormat.getTooltip().isEmpty()) {
            fancyMessage.tooltip(deluxePrivateMessageFormat.getTooltip());
        }
        if (deluxePrivateMessageFormat.getClickAction() != null) {
            String string3 = deluxePrivateMessageFormat.getClickAction();
            if (string3.startsWith("[EXECUTE]")) {
                string3 = string3.replace("[EXECUTE]", "");
                fancyMessage.command(string3);
            } else if (string3.startsWith("[URL]")) {
                if (!(string3 = string3.replace("[URL]", "")).startsWith("http://") && !string3.startsWith("https://")) {
                    string3 = "http://" + string3;
                }
                fancyMessage.link(string3);
            } else {
                fancyMessage.suggest(string3);
            }
        }
        fancyMessage.then(ChatColor.translateAlternateColorCodes((char)'&', (String)"&f"));
        return fancyMessage;
    }

    public FancyMessage getPrivateMessageFormat(DeluxePrivateMessageFormat deluxePrivateMessageFormat) {
        if (deluxePrivateMessageFormat == null) {
            return null;
        }
        String string = deluxePrivateMessageFormat.getFormat();
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        FancyMessage fancyMessage = new FancyMessage(string);
        String string2 = DeluxeUtil.getLastColor(string);
        fancyMessage.setLastColor(string2);
        fancyMessage.setChatColor(ChatColor.translateAlternateColorCodes((char)'&', (String)deluxePrivateMessageFormat.getChatColor()));
        if (deluxePrivateMessageFormat.getTooltip() != null && !deluxePrivateMessageFormat.getTooltip().isEmpty()) {
            fancyMessage.tooltip(deluxePrivateMessageFormat.getTooltip());
        }
        if (deluxePrivateMessageFormat.getClickAction() != null) {
            String string3 = deluxePrivateMessageFormat.getClickAction();
            if (string3.startsWith("[EXECUTE]")) {
                string3 = string3.replace("[EXECUTE]", "");
                fancyMessage.command(string3);
            } else if (string3.startsWith("[URL]")) {
                if (!(string3 = string3.replace("[URL]", "")).startsWith("http://") && !string3.startsWith("https://")) {
                    string3 = "http://" + string3;
                }
                fancyMessage.link(string3);
            } else {
                fancyMessage.suggest(string3);
            }
        }
        fancyMessage.then(ChatColor.translateAlternateColorCodes((char)'&', (String)"&f"));
        return fancyMessage;
    }

    public FancyMessage getFancyChatFormat(Player player, DeluxeFormat deluxeFormat) {
        String string;
        String string2;
        String string3;
        String string4;
        if (deluxeFormat == null) {
            return null;
        }
        FancyMessage fancyMessage = null;
        String string5 = "";
        String string6 = deluxeFormat.getChannel();
        if (string6 != null && !string6.isEmpty()) {
            string6 = PlaceholderHandler.setPlaceholders(player, string6);
            string5 = DeluxeUtil.getLastColor(string6);
            fancyMessage = new FancyMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)string6));
            if (deluxeFormat.useChannelClick() && deluxeFormat.getChannelClickCommand() != null) {
                string4 = PlaceholderHandler.setPlaceholders(player, deluxeFormat.getChannelClickCommand());
                if (string4.startsWith("[EXECUTE]")) {
                    string4 = string4.replace("[EXECUTE]", "");
                    fancyMessage.command(ChatColor.translateAlternateColorCodes((char)'&', (String)string4));
                } else if (string4.startsWith("[URL]")) {
                    if (!(string4 = string4.replace("[URL]", "")).startsWith("http://") && !string4.startsWith("https://")) {
                        string4 = "http://" + string4;
                    }
                    fancyMessage.link(string4);
                } else {
                    fancyMessage.suggest(ChatColor.translateAlternateColorCodes((char)'&', (String)string4));
                }
            }
            if (deluxeFormat.showChannelTooltip() && deluxeFormat.getChannelTooltip() != null) {
                fancyMessage.tooltip(PlaceholderHandler.setPlaceholders(player, deluxeFormat.getChannelTooltip()));
            }
        }
        if ((string4 = deluxeFormat.getPrefix()) != null && !string4.isEmpty()) {
            string4 = PlaceholderHandler.setPlaceholders(player, string4);
            if (fancyMessage == null) {
                fancyMessage = new FancyMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)string4));
            } else {
                fancyMessage.then(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(string5) + string4)));
            }
            string5 = DeluxeUtil.getLastColor(string4);
            if (deluxeFormat.usePreClick() && deluxeFormat.getPreClickCmd() != null) {
                string3 = PlaceholderHandler.setPlaceholders(player, deluxeFormat.getPreClickCmd());
                if (string3.startsWith("[EXECUTE]")) {
                    string3 = string3.replace("[EXECUTE]", "");
                    fancyMessage.command(ChatColor.translateAlternateColorCodes((char)'&', (String)string3));
                } else if (string3.startsWith("[URL]")) {
                    if (!(string3 = string3.replace("[URL]", "")).startsWith("http://") && !string3.startsWith("https://")) {
                        string3 = "http://" + string3;
                    }
                    fancyMessage.link(string3);
                } else {
                    fancyMessage.suggest(ChatColor.translateAlternateColorCodes((char)'&', (String)string3));
                }
            }
            if (deluxeFormat.showPreTooltip() && deluxeFormat.getPrefixTooltip() != null) {
                fancyMessage.tooltip(PlaceholderHandler.setPlaceholders(player, deluxeFormat.getPrefixTooltip()));
            }
        }
        if ((string3 = deluxeFormat.getName()) != null && !string3.isEmpty()) {
            string3 = PlaceholderHandler.setPlaceholders(player, deluxeFormat.getName());
            string2 = "";
            if (deluxeFormat.getNameColor() != null) {
                string2 = PlaceholderHandler.setPlaceholders(player, deluxeFormat.getNameColor());
            }
            if (fancyMessage == null) {
                fancyMessage = new FancyMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(string2) + string3)));
            } else {
                fancyMessage.then(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(string5) + string2 + string3)));
            }
            string5 = DeluxeUtil.getLastColor(String.valueOf(string2) + string3);
            if (deluxeFormat.useNameClick() && deluxeFormat.getNameClickCmd() != null) {
                string = PlaceholderHandler.setPlaceholders(player, deluxeFormat.getNameClickCmd());
                if (string.startsWith("[EXECUTE]")) {
                    string = string.replace("[EXECUTE]", "");
                    fancyMessage.command(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
                } else if (string.startsWith("[URL]")) {
                    if (!(string = string.replace("[URL]", "")).startsWith("http://") && !string.startsWith("https://")) {
                        string = "http://" + string;
                    }
                    fancyMessage.link(string);
                } else {
                    fancyMessage.suggest(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
                }
            }
            if (deluxeFormat.showNameTooltip() && deluxeFormat.getNameTooltip() != null) {
                fancyMessage.tooltip(PlaceholderHandler.setPlaceholders(player, deluxeFormat.getNameTooltip()));
            }
        }
        if ((string2 = deluxeFormat.getSuffix()) != null && !string2.isEmpty()) {
            string2 = PlaceholderHandler.setPlaceholders(player, deluxeFormat.getSuffix());
            if (fancyMessage == null) {
                fancyMessage = new FancyMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)string2));
            } else {
                fancyMessage.then(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(string5) + string2)));
            }
            string5 = DeluxeUtil.getLastColor(String.valueOf(string5) + string2);
            if (deluxeFormat.useSuffixClick() && deluxeFormat.getSuffixClickCmd() != null) {
                string = PlaceholderHandler.setPlaceholders(player, deluxeFormat.getSuffixClickCmd());
                if (string.startsWith("[EXECUTE]")) {
                    string = string.replace("[EXECUTE]", "");
                    fancyMessage.command(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
                } else if (string.startsWith("[URL]")) {
                    if (!(string = string.replace("[URL]", "")).startsWith("http://") && !string.startsWith("https://")) {
                        string = "http://" + string;
                    }
                    fancyMessage.link(string);
                } else {
                    fancyMessage.suggest(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
                }
            }
            if (deluxeFormat.showSuffixTooltip() && deluxeFormat.getSuffixTooltip() != null) {
                fancyMessage.tooltip(PlaceholderHandler.setPlaceholders(player, deluxeFormat.getSuffixTooltip()));
            }
        }
        string = "";
        if (deluxeFormat.getChatColor() != null && !deluxeFormat.getChatColor().isEmpty()) {
            string = PlaceholderHandler.setPlaceholders(player, deluxeFormat.getChatColor());
        }
        fancyMessage.setLastColor(ChatColor.translateAlternateColorCodes((char)'&', (String)string5));
        if (string != null && !string.isEmpty()) {
            fancyMessage.setChatColor(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(string5) + string)));
        }
        return fancyMessage;
    }

    public String setRelationPlaceholders(Player player, Player player2, String string) {
        if (!useRelationPlaceholders) {
            return string;
        }
        if (string.contains("%recipient_name%")) {
            string = string.replace("%recipient_name%", player2.getName());
        }
        if (string.contains("%recipient_displayname%")) {
            string = string.replace("%recipient_displayname%", player2.getDisplayName());
        }
        return PlaceholderHandler.setRecipientPlaceholders(player, player2, string);
    }

    public static boolean useBungee() {
        return bungee != null;
    }

    public static boolean enableSocialSpy(String string) {
        if (socialSpy == null) {
            socialSpy = new ArrayList<String>();
            socialSpy.add(string);
            return true;
        }
        if (socialSpy.contains(string)) {
            return false;
        }
        socialSpy.add(string);
        return true;
    }

    public static boolean enableSocialSpy(Player player) {
        return DeluxeChat.enableSocialSpy(player.getUniqueId().toString());
    }

    public static boolean disableSocialSpy(String string) {
        if (socialSpy == null) {
            socialSpy = new ArrayList<String>();
            return false;
        }
        if (!socialSpy.contains(string)) {
            return false;
        }
        socialSpy.remove(string);
        return true;
    }

    public static boolean disableSocialSpy(Player player) {
        return DeluxeChat.disableSocialSpy(player.getUniqueId().toString());
    }

    public static boolean inSocialSpy(String string) {
        if (socialSpy == null) {
            return false;
        }
        return socialSpy.contains(string);
    }

    public static boolean inSocialSpy(Player player) {
        return DeluxeChat.inSocialSpy(player.getUniqueId().toString());
    }

    public boolean setLocal(String string) {
        if (localPlayers == null) {
            localPlayers = new ArrayList<String>();
            localPlayers.add(string);
            return true;
        }
        if (localPlayers.contains(string)) {
            return false;
        }
        localPlayers.add(string);
        return true;
    }

    public boolean setGlobal(String string) {
        if (localPlayers == null) {
            localPlayers = new ArrayList<String>();
            return false;
        }
        if (!localPlayers.contains(string)) {
            return false;
        }
        localPlayers.remove(string);
        return true;
    }

    public static boolean isLocal(String string) {
        if (localPlayers == null) {
            return false;
        }
        return localPlayers.contains(string);
    }

    public static void forwardString(Player player, String string, String string2, boolean bl) {
        if (!DeluxeChat.useBungee()) {
            return;
        }
        try {
            ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
            byteArrayDataOutput.writeUTF(string);
            byteArrayDataOutput.writeUTF(string2);
            byteArrayDataOutput.writeBoolean(bl);
            player.sendPluginMessage((Plugin)instance, "DeluxeChat", byteArrayDataOutput.toByteArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void forwardPm(Player player, PrivateMessageType privateMessageType, String string, String string2, String string3, String string4) {
        if (!DeluxeChat.useBungee()) {
            return;
        }
        try {
            ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
            byteArrayDataOutput.writeUTF(privateMessageType.getType());
            byteArrayDataOutput.writeUTF(player.getName());
            byteArrayDataOutput.writeUTF(string);
            byteArrayDataOutput.writeUTF(string2);
            byteArrayDataOutput.writeUTF(string3);
            byteArrayDataOutput.writeUTF(string4);
            player.sendPluginMessage((Plugin)instance, "DeluxeChatPM", byteArrayDataOutput.toByteArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean globalOnJoin() {
        return joinGlobal;
    }

    public static String getServerName() {
        return serverName != null ? serverName : "";
    }

    public static boolean useRelationPlaceholders() {
        return useRelationPlaceholders;
    }

    public static boolean bungeePMEnabled() {
        return bungeePM;
    }

    public static SimpleDateFormat getTimestampFormat() {
        return timestampFormat;
    }

    public static String getBooleanTrue() {
        return booleanTrue != null ? booleanTrue : "true";
    }

    public static String getBooleanFalse() {
        return booleanFalse != null ? booleanFalse : "false";
    }

    public static String getSocialSpyFormat() {
        return socialSpyFormat;
    }

    public static DeluxePrivateMessageFormat getToSenderPMFormat() {
        return DeluxePrivateMessageFormat.newInstance(toSenderPmFormat);
    }

    public static DeluxePrivateMessageFormat getToRecipientPMFormat() {
        return DeluxePrivateMessageFormat.newInstance(toRecipientPmFormat);
    }

    public static void setInPm(String string, String string2) {
        if (inPrivateChat == null) {
            inPrivateChat = new HashMap<String, String>();
        }
        inPrivateChat.put(string, string2);
    }

    public static void removeFromPM(String string) {
        if (inPrivateChat == null) {
            return;
        }
        if (inPrivateChat.containsKey(string)) {
            inPrivateChat.remove(string);
        }
    }

    public static String getPmRecipient(String string) {
        if (inPrivateChat == null) {
            return null;
        }
        if (inPrivateChat.containsKey(string)) {
            return inPrivateChat.get(string);
        }
        return null;
    }

    public static void setUseEssentials(boolean bl) {
        useEssentials = bl;
    }

    public static boolean useEssentials() {
        return useEssentials;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("http://www.spigotmc.org/api/resource.php?user_id=47710&resource_id=1277&nonce=1620322292").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled due to piracy! Please contact SpigotMC!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

